/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mobac.Main;
import mobac.exceptions.MapSourcesUpdateException;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.UpdatableMapSource;
import mobac.program.DirectoryManager;
import mobac.program.model.Settings;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class MapSourcesUpdater {
    private static boolean mapSourcesExternalFileUsed = false;
    private static final Logger log = Logger.getLogger(MapSourcesUpdater.class);
    private static final Pattern SVN_REV = Pattern.compile("\\$Rev\\:\\s*(\\d*)\\s*\\$");
    private static final Pattern SVN_DATE = Pattern.compile("\\$Date\\:\\s*([\\d\\s:\\-\\+]*) \\(.*\\)\\s*\\$");
    private static final SimpleDateFormat SVN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public static void loadMapSourceProperties() {
        Properties systemProps = System.getProperties();
        MapSourcesUpdater.loadMapSourceProperties(systemProps);
    }

    public static int getMapSourcesRev(Properties p) {
        String revS = p.getProperty("mapsources.Rev");
        if (revS == null) {
            return -1;
        }
        return MapSourcesUpdater.parseMapSourcesRev(revS);
    }

    private static int parseMapSourcesRev(String s) {
        if (s == null) {
            return -1;
        }
        Matcher m = SVN_REV.matcher(s);
        if (!m.matches()) {
            return -1;
        }
        s = m.group(1);
        return Integer.parseInt(s);
    }

    public static Date getMapSourcesDate(Properties p) {
        String revS = p.getProperty("mapsources.Date");
        if (revS == null) {
            return null;
        }
        return MapSourcesUpdater.parseMapSourcesDate(revS);
    }

    private static Date parseMapSourcesDate(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = SVN_DATE.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String part = m.group(1);
        try {
            return SVN_DATE_FORMAT.parse(part);
        }
        catch (ParseException e) {
            log.error("", e);
            return null;
        }
    }

    public static void automaticMapsourcesOnlineUpdate(boolean async) {
        Date lastUpdate = Settings.getInstance().mapSourcesUpdate.lastUpdate;
        if (lastUpdate == null) {
            lastUpdate = MapSourcesUpdater.getMapSourcesDate(System.getProperties());
        }
        Date end = new Date();
        long diff = end.getTime() - lastUpdate.getTime();
        if ((diff /= 86400000L) < 4L) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Performing a map sources update");
                    boolean result = MapSourcesUpdater.mapsourcesOnlineUpdate();
                    if (result) {
                        log.info("Updated map sources file retrieved");
                    } else {
                        log.info("No new update available");
                    }
                }
                catch (MapSourcesUpdateException e) {
                    log.error("Scheduled map sources update failed:", e);
                }
            }
        };
        if (async) {
            new Thread(r, "MapSourcesUpdate").start();
        } else {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapsourcesOnlineUpdate() throws MapSourcesUpdateException {
        try {
            block10: {
                File mapFile = new File(DirectoryManager.currentDir, "mapsources.properties");
                String mapUpdateUrl = System.getProperty("mobac.updateurl");
                if (mapUpdateUrl == null) {
                    throw new MapSourcesUpdateException("No update url configured!");
                }
                URL url = new URL(mapUpdateUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                Settings settings = Settings.getInstance();
                if (mapFile.isFile() && settings.mapSourcesUpdate.etag != null && settings.mapSourcesUpdate.etag != "") {
                    conn.addRequestProperty("If-None-Match", settings.mapSourcesUpdate.etag);
                }
                int code = conn.getResponseCode();
                log.trace("Mapsources online update: \n\tUpdate url: " + mapUpdateUrl + "\n\tResponse  : " + code + " " + conn.getResponseMessage() + "\n\tSize      : " + conn.getContentLength() + " bytes \n\tETag      : " + conn.getHeaderField("ETag"));
                if (code == 304) {
                    return false;
                }
                if (code != 200) {
                    throw new MapSourcesUpdateException("Invalid HTTP server response: " + code + " " + conn.getResponseMessage());
                }
                DataInputStream in = new DataInputStream(conn.getInputStream());
                if (conn.getContentLength() == 0) {
                    throw new MapSourcesUpdateException("This version of Mobile Atlas Creator is no longer supported. \nPlease update to the current version.");
                }
                byte[] data = new byte[conn.getContentLength()];
                in.readFully(data);
                in.close();
                conn.disconnect();
                Properties onlineProps = new Properties();
                onlineProps.load(new ByteArrayInputStream(data));
                int onlineRev = MapSourcesUpdater.getMapSourcesRev(onlineProps);
                int currentRev = MapSourcesUpdater.parseMapSourcesRev(System.getProperty("mapsources.Rev"));
                settings.mapSourcesUpdate.lastUpdate = new Date();
                settings.mapSourcesUpdate.etag = conn.getHeaderField("ETag");
                if (onlineRev <= currentRev && mapSourcesExternalFileUsed) break block10;
                System.getProperties().putAll((Map<?, ?>)onlineProps);
                FileOutputStream mapFs = null;
                try {
                    mapFs = new FileOutputStream(mapFile);
                    mapFs.write(data);
                }
                catch (Throwable throwable) {
                    Utilities.closeStream(mapFs);
                    throw throwable;
                }
                Utilities.closeStream(mapFs);
                for (MapSource ms : MapSourcesManager.getAllMapSources()) {
                    if (!(ms instanceof UpdatableMapSource)) continue;
                    ((UpdatableMapSource)((Object)ms)).update();
                }
                mapSourcesExternalFileUsed = true;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new MapSourcesUpdateException(e);
        }
    }

    public static void loadMapSourceProperties(Properties properties) {
        try {
            Properties properties2;
            URL uRL = Main.class.getResource("mapsources.properties");
            File file = new File(DirectoryManager.currentDir, "mapsources.properties");
            Properties properties3 = new Properties();
            Properties properties4 = new Properties();
            Utilities.loadProperties(properties3, uRL);
            if (file.isFile()) {
                Utilities.loadProperties(properties4, file);
                int n = MapSourcesUpdater.getMapSourcesRev(properties4);
                int n2 = MapSourcesUpdater.getMapSourcesRev(properties3);
                log.trace("mapsources.properties revisons (resource/file): " + n2 + " / " + n);
                properties2 = n < n2 ? properties3 : properties4;
            } else {
                properties2 = properties3;
            }
            boolean bl = mapSourcesExternalFileUsed = properties2 != properties3;
            if (mapSourcesExternalFileUsed) {
                log.debug("Used mapsources.properties: file");
            } else {
                log.debug("Used mapsources.properties: resource");
            }
            properties.putAll((Map<?, ?>)properties2);
        }
        catch (Exception exception) {
            log.error("Error while reading mapsources.properties: ", exception);
            GUIExceptionHandler.showExceptionDialog(exception);
        }
    }
}

