/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import mobac.mapsources.AbstractMapSource;
import mobac.mapsources.MapSourceTools;
import mobac.mapsources.MultiLayerMapSource;
import mobac.mapsources.UpdatableMapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class Google {
    public static String LANG = "en";

    public static class GoogleHybrid
    extends GoogleEarthMapsOverlay
    implements MultiLayerMapSource {
        private final MapSource background = new GoogleEarth();

        @Override
        public String getName() {
            return "Google Hybrid";
        }

        @Override
        public String toString() {
            return "Google Hybrid";
        }

        @Override
        public MapSource getBackgroundMapSource() {
            return this.background;
        }
    }

    public static class GoogleEarthMapsOverlay
    extends GoogleSource {
        public GoogleEarthMapsOverlay() {
            super("Google Earth Maps Overlay", 0, 20, "png", MapSource.TileUpdate.IfModifiedSince);
        }
    }

    public static class GoogleEarth
    extends GoogleSource {
        public GoogleEarth() {
            super("Google Earth", 0, 20, "jpg", MapSource.TileUpdate.IfModifiedSince);
        }
    }

    public static class GoogleMapsKorea
    extends GoogleSource {
        public GoogleMapsKorea() {
            super("Google Maps Korea", 0, 18, "png", MapSource.TileUpdate.None);
        }

        @Override
        public String toString() {
            return "Google Maps Korea";
        }
    }

    public static class GoogleMapsChina
    extends GoogleSource {
        public GoogleMapsChina() {
            super("Google Maps China", 0, 19, "png", MapSource.TileUpdate.IfModifiedSince);
        }

        @Override
        public String toString() {
            return "Google Maps China (Ditu)";
        }
    }

    public static class GoogleTerrain
    extends GoogleSource {
        public GoogleTerrain() {
            super("Google Terrain", 0, 15, "jpg", MapSource.TileUpdate.IfModifiedSince);
        }
    }

    public static class GoogleMapMaker
    extends GoogleSource {
        public GoogleMapMaker() {
            super("Google Map Maker", 1, 17, "png", MapSource.TileUpdate.IfModifiedSince);
        }
    }

    public static class GoogleMaps
    extends GoogleSource {
        public GoogleMaps() {
            super("Google Maps", 0, 19, "png", MapSource.TileUpdate.IfModifiedSince);
        }
    }

    public static abstract class GoogleSource
    extends AbstractMapSource
    implements UpdatableMapSource {
        private int serverNum = 0;
        public String serverUrl;

        public GoogleSource(String name, int minZoom, int maxZoom, String tileType, MapSource.TileUpdate tileUpdate) {
            super(name, minZoom, maxZoom, tileType, tileUpdate);
            this.update();
        }

        @Override
        public void update() {
            this.serverUrl = MapSourceTools.loadMapUrl(this, "url");
        }

        protected int getNextServerNum() {
            int x = this.serverNum;
            this.serverNum = (this.serverNum + 1) % 4;
            return x;
        }

        @Override
        public String getTileUrl(int zoom, int x, int y) {
            String tmp = this.serverUrl;
            tmp = tmp.replace("{$servernum}", Integer.toString(this.getNextServerNum()));
            tmp = tmp.replace("{$lang}", LANG);
            tmp = tmp.replace("{$x}", Integer.toString(x));
            tmp = tmp.replace("{$y}", Integer.toString(y));
            tmp = tmp.replace("{$z}", Integer.toString(zoom));
            return tmp;
        }
    }
}

