/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import mobac.mapsources.AbstractMapSource;
import mobac.mapsources.MapSourceTools;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class Microsoft {

    public static class MicrosoftHybrid
    extends AbstractMicrosoft {
        public MicrosoftHybrid() {
            super("Microsoft Hybrid", "jpg", 'h', MapSource.TileUpdate.None);
        }

        @Override
        public String toString() {
            return "Microsoft Maps/Earth Hybrid";
        }
    }

    public static class MicrosoftVirtualEarth
    extends AbstractMicrosoft {
        public MicrosoftVirtualEarth() {
            super("Microsoft Virtual Earth", "jpg", 'a', MapSource.TileUpdate.IfNoneMatch);
        }
    }

    public static class MicrosoftMapsChina
    extends AbstractMicrosoft {
        public MicrosoftMapsChina() {
            super("Microsoft Maps China", "png", 'r', MapSource.TileUpdate.IfNoneMatch);
            this.urlBase = ".tiles.ditu.live.com/tiles/";
            this.urlAppend = "?g=1";
            this.maxZoom = 18;
        }
    }

    public static class MicrosoftMaps
    extends AbstractMicrosoft {
        public MicrosoftMaps() {
            super("Microsoft Maps", "png", 'r', MapSource.TileUpdate.IfNoneMatch);
        }
    }

    public static abstract class AbstractMicrosoft
    extends AbstractMapSource {
        protected String urlBase = ".ortho.tiles.virtualearth.net/tiles/";
        protected String urlAppend = "?g=45";
        protected int serverNum = 0;
        protected int serverNumMax = 4;
        protected char mapTypeChar;

        public AbstractMicrosoft(String name, String tileType, char mapTypeChar, MapSource.TileUpdate tileUpdate) {
            super(name, 1, 19, tileType, tileUpdate);
            this.mapTypeChar = mapTypeChar;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String tileNum = MapSourceTools.encodeQuadTree(zoom, tilex, tiley);
            this.serverNum = (this.serverNum + 1) % this.serverNumMax;
            return "http://" + this.mapTypeChar + this.serverNum + this.urlBase + this.mapTypeChar + tileNum + "." + this.tileType + this.urlAppend;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

