/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import mobac.mapsources.AbstractMapSource;
import mobac.mapsources.MapSourceTools;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class MiscMapSources {

    public static class OviMaps
    extends AbstractMapSource {
        public OviMaps() {
            super("Ovi Maps", 1, 18, "png");
            this.tileUpdate = MapSource.TileUpdate.IfModifiedSince;
        }

        @Override
        public String getTileUrl(int zoom, int x, int y) {
            return "http://maptile.maps.svc.ovi.com/maptiler/maptile/newest/normal.day/" + zoom + "/" + x + "/" + y + "/256/png8?token=...&referer=maps.ovi.com";
        }

        @Override
        public String toString() {
            return "Ovi/Nokia Maps";
        }
    }

    public static class YahooMaps
    extends AbstractMapSource {
        public YahooMaps() {
            super("Yahoo Maps", 1, 16, "jpg");
            this.tileUpdate = MapSource.TileUpdate.IfModifiedSince;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            int yahooTileY = ((1 << zoom) - 2) / 2 - tiley;
            int yahooZoom = this.getMaxZoom() - zoom + 2;
            return "http://maps.yimg.com/hw/tile?locale=en&imgtype=png&yimgv=1.2&v=4.1&x=" + tilex + "&y=" + yahooTileY + "+6163&z=" + yahooZoom;
        }
    }

    public static class MultimapOSUkCom
    extends AbstractMapSource {
        public MultimapOSUkCom() {
            super("Multimap UK OS Map", 1, 16, "png", MapSource.TileUpdate.IfModifiedSince);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String tileNum = MapSourceTools.encodeQuadTree(zoom, tilex, tiley);
            if (tileNum.length() > 12) {
                tileNum = tileNum.substring(0, 6) + "/" + tileNum.substring(6, 12) + "/" + tileNum.substring(12);
            } else if (tileNum.length() > 6) {
                tileNum = tileNum.substring(0, 6) + "/" + tileNum.substring(6);
            }
            String base = zoom < 6 ? "http://mc1.tiles-cdn.multimap.com/ptiles/map/mi915/" : (zoom < 14 ? "http://mc2.tiles-cdn.multimap.com/ptiles/map/mi917/" : (zoom < 15 ? "http://mc0.tiles-cdn.multimap.com/ptiles/map/mi904/" : "http://mc0.tiles-cdn.multimap.com/ptiles/map/mi932/"));
            tileNum = base + (zoom + 1) + "/" + tileNum + ".png?client=public_api&service_seq=14458";
            return tileNum;
        }
    }

    public static class MultimapCom
    extends AbstractMapSource {
        public MultimapCom() {
            super("Multimap.com", 1, 17, "png", MapSource.TileUpdate.IfModifiedSince);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String tileNum = MapSourceTools.encodeQuadTree(zoom, tilex, tiley);
            if (tileNum.length() > 12) {
                tileNum = tileNum.substring(0, 6) + "/" + tileNum.substring(6, 12) + "/" + tileNum.substring(12);
            } else if (tileNum.length() > 6) {
                tileNum = tileNum.substring(0, 6) + "/" + tileNum.substring(6);
            }
            String base = zoom < 6 ? "http://mc1.tiles-cdn.multimap.com/ptiles/map/mi915/" : (zoom < 14 ? "http://mc2.tiles-cdn.multimap.com/ptiles/map/mi917/" : "http://mc3.tiles-cdn.multimap.com/ptiles/map/mi931/");
            tileNum = base + (zoom + 1) + "/" + tileNum + ".png?client=public_api&service_seq=14458";
            return tileNum;
        }
    }
}

