/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import java.awt.Color;
import mobac.mapsources.AbstractMapSource;
import mobac.mapsources.MultiLayerMapSource;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class OsmMapSources {

    public static class Turaterkep
    extends AbstractMapSource {
        private MapSpace space = new MercatorPower2MapSpace(512);

        public Turaterkep() {
            super("Turaterkep", 7, 16, "png", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://turaterkep.hostcity.hu/tiles/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }

        @Override
        public MapSpace getMapSpace() {
            return this.space;
        }

        @Override
        public String toString() {
            return "Turaterkep (Hungary)";
        }

        @Override
        public Color getBackgroundColor() {
            return Color.WHITE;
        }
    }

    public static class OpenPisteMap
    extends AbstractMapSource {
        public OpenPisteMap() {
            super("OpenPisteMap", 0, 17, "png", MapSource.TileUpdate.LastModified);
        }

        @Override
        public String toString() {
            return "Open Piste Map";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://openpistemap.org/tiles/contours/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }
    }

    public static class OsmHikingMapWithBase
    extends OsmHikingMap
    implements MultiLayerMapSource {
        private MapSource background = new OsmHikingBase();

        @Override
        public String toString() {
            return "OpenStreetMap Hiking with Base";
        }

        @Override
        public String getName() {
            return "OSM Hiking with Base";
        }

        @Override
        public MapSource getBackgroundMapSource() {
            return this.background;
        }
    }

    public static class OsmHikingMapWithRelief
    extends OsmHikingMap
    implements MultiLayerMapSource {
        private MapSource background = new OsmHikingRelief();

        @Override
        public String toString() {
            return "OpenStreetMap Hiking with Relief";
        }

        @Override
        public String getName() {
            return "OSM Hiking with Relief";
        }

        @Override
        public int getMaxZoom() {
            return 15;
        }

        @Override
        public MapSource getBackgroundMapSource() {
            return this.background;
        }
    }

    public static class OsmHikingBase
    extends AbstractMapSource {
        public OsmHikingBase() {
            super("OSM Hiking Base", 4, 18, "png", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String toString() {
            return "OpenStreetMap Hiking Base only (Germany only)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://topo.openstreetmap.de/base/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }
    }

    public static class OsmHikingRelief
    extends AbstractMapSource {
        public OsmHikingRelief() {
            super("OSM Hiking Relief", 4, 15, "png", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String toString() {
            return "OpenStreetMap Hiking Relief only (Germany only)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://topo.geofabrik.de/hills/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }
    }

    public static class OsmHikingMap
    extends AbstractMapSource {
        public OsmHikingMap() {
            super("OSM Hiking", 4, 18, "png", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String toString() {
            return "OpenStreetMap Hiking (Germany only)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://topo.openstreetmap.de/topo/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }
    }

    public static class TilesAtHome
    extends AbstractOsmTileSource {
        public TilesAtHome() {
            super("TilesAtHome");
            this.maxZoom = 17;
            this.tileUpdate = MapSource.TileUpdate.IfModifiedSince;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://tah.openstreetmap.org/Tiles/tile" + super.getTileUrl(zoom, tilex, tiley);
        }

        @Override
        public String toString() {
            return "OpenStreetMap Osmarenderer";
        }
    }

    public static class OsmPublicTransport
    extends AbstractOsmTileSource {
        public OsmPublicTransport() {
            super("OSMPublicTransport");
            this.maxZoom = 16;
            this.minZoom = 2;
            this.tileUpdate = MapSource.TileUpdate.ETag;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String url = String.format("http://tile.xn--pnvkarte-m4a.de/tilegen/%d/%d/%d.png", zoom, tilex, tiley);
            return url;
        }

        @Override
        public String toString() {
            return "OpenStreetMap Public Transport";
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public CycleMap() {
            super("OSM Cycle Map");
            this.maxZoom = 17;
            this.tileUpdate = MapSource.TileUpdate.ETag;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String url = String.format("http://%s.andy.sandbox.cloudmade.com/tiles/cycle/%d/%d/%d.png", SERVER[this.SERVER_NUM], zoom, tilex, tiley);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        @Override
        public String toString() {
            return "OpenStreetMap Cyclemap";
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik() {
            super("Mapnik");
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://tile.openstreetmap.org" + super.getTileUrl(zoom, tilex, tiley);
        }

        @Override
        public MapSource.TileUpdate getTileUpdate() {
            return MapSource.TileUpdate.IfNoneMatch;
        }

        @Override
        public String toString() {
            return "OpenStreetMap Mapnik";
        }
    }

    protected static abstract class AbstractOsmTileSource
    extends AbstractMapSource {
        public AbstractOsmTileSource(String name) {
            super(name, 0, 18, "png");
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }

        @Override
        public String getTileType() {
            return "png";
        }

        @Override
        public boolean allowFileStore() {
            return true;
        }
    }
}

