/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Random;
import mobac.mapsources.AbstractMapSource;
import mobac.mapsources.MapSourceTools;
import mobac.mapsources.UpdatableMapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class RegionalMapSources {

    public static class Bergfex
    extends AbstractMapSource {
        int SERVERNUM = 0;

        public Bergfex() {
            super("Bergfex", 8, 15, "png", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String toString() {
            return "Bergfex (Austria)";
        }

        @Override
        public String getTileUrl(int zoom, int x, int y) {
            String baseurl = "http://static" + (this.SERVERNUM + 2) + ".bergfex.at/images/amap/";
            this.SERVERNUM = (this.SERVERNUM + 1) % 3;
            String xBase = "";
            if (zoom > 13) {
                xBase = Integer.toString(x).substring(0, zoom - 12) + "/";
            }
            return baseurl + zoom + "/" + xBase + zoom + "_" + x + "_" + y + ".png";
        }
    }

    public static class MapplusCh
    extends AbstractMapSource {
        String referer;
        private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        public MapplusCh() {
            super("MapplusCh", 7, 16, "jpg", MapSource.TileUpdate.ETag);
            char[] sessID = new char[32];
            Random rnd = new Random();
            for (int i = 0; i < sessID.length; ++i) {
                sessID[i] = hex[rnd.nextInt(hex.length)];
            }
            this.referer = "http://www.mapplus.ch/NeapoljsMapPage.php?uid=public&group=public&sessID=" + new String(sessID);
        }

        @Override
        public String toString() {
            return "Map+ (Switzerland)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            int z = 17 - zoom;
            return "http://mp2.mapplus.ch/kacache/" + z + "/def/def/t" + tiley + "/l" + tilex + "/t" + tiley + "l" + tilex + ".jpg";
        }

        @Override
        public HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
            HttpURLConnection conn = super.getTileUrlConnection(zoom, tilex, tiley);
            conn.setRequestProperty("Referer", this.referer);
            return conn;
        }
    }

    public static class EniroComAerial
    extends EniroComMap {
        public EniroComAerial() {
            super("aerial");
        }

        @Override
        public String toString() {
            return "Eniro Aerial (SE, NO, FI)";
        }
    }

    public static class EniroComNautical
    extends EniroComMap {
        public EniroComNautical() {
            super("nautical");
        }

        @Override
        public String toString() {
            return "Eniro Nautical (SE, NO, FI)";
        }
    }

    public static class EniroComMap
    extends AbstractMapSource {
        private String mapType;

        public EniroComMap() {
            this("map");
        }

        protected EniroComMap(String mapType) {
            super("Eniro.com-" + mapType, 0, 20, "png", MapSource.TileUpdate.IfModifiedSince);
            this.mapType = mapType;
        }

        @Override
        public String toString() {
            return "Eniro Map (SE, NO, FI)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            int y = (1 << zoom) - 1 - tiley;
            return "http://map.eniro.com/geowebcache/service/tms1.0.0/" + this.mapType + "/" + zoom + "/" + tilex + "/" + y + ".png";
        }
    }

    public static class StatkartToporaster2
    extends StatkartTopo2 {
        public StatkartToporaster2() {
            super("toporaster2", "Statkart Toporaster 2", 0, 17, "png", MapSource.TileUpdate.None);
        }
    }

    public static class StatkartTopo2
    extends AbstractMapSource {
        final String service;

        public StatkartTopo2() {
            this("topo2", "Statkart Topo 2", 0, 17, "png", MapSource.TileUpdate.None);
        }

        public StatkartTopo2(String service, String name, int minZoom, int maxZoom, String tileType, MapSource.TileUpdate tileUpdate) {
            super(name, minZoom, maxZoom, tileType, tileUpdate);
            this.service = service;
        }

        @Override
        public String toString() {
            return this.getName() + " (Norway)";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://opencache.statkart.no/gatekeeper/gk/gk.open_gmaps?layers=" + this.service + "&zoom=" + zoom + "&x=" + tilex + "&y=" + tiley;
        }
    }

    public static class HubermediaBavaria
    extends AbstractMapSource {
        String[] mapUrls = new String[17];
        int serverNum = 0;

        public HubermediaBavaria() {
            super("Hubermedia Bavaria", 10, 16, "png", MapSource.TileUpdate.IfNoneMatch);
            this.mapUrls[10] = "http://t0.hubermedia.de/TK500/DE/Bayern/";
            this.mapUrls[11] = this.mapUrls[10];
            this.mapUrls[12] = "http://t{$servernum}.wms.hubermedia.de/tk200/de/bayern//Z{$z}/{$y}/{$x}.png";
            this.mapUrls[13] = "http://t{$servernum}.hubermedia.de/TK50/DE/Bayern//Z{$z}/{$y}/{$x}.png";
            this.mapUrls[14] = this.mapUrls[13];
            this.mapUrls[15] = "http://t{$servernum}.hubermedia.de/TK25/DE/Bayern//Z{$z}/{$y}/{$x}.png";
            this.mapUrls[16] = "http://t{$servernum}.hubermedia.de/DOK/DE/Bayern//Z{$z}/{$y}/{$x}.png";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            this.serverNum = (this.serverNum + 1) % 3;
            if (zoom >= 12) {
                return MapSourceTools.formatMapUrl(this.mapUrls[zoom], this.serverNum, zoom, tilex, tiley);
            }
            String tc = MapSourceTools.encodeQuadTree(zoom, tilex, tiley);
            return this.mapUrls[zoom] + zoom + "/" + tc + ".png";
        }
    }

    public static class NearMap
    extends AbstractMapSource {
        public NearMap() {
            super("NearMap Australia", 0, 21, "jpg", MapSource.TileUpdate.IfNoneMatch);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://www.nearmap.com/maps/hl=en&nml=Vert&z=" + zoom + "&x=" + tilex + "&y=" + tiley;
        }
    }

    public static class EmapaPl
    extends AbstractMapSource {
        public EmapaPl() {
            super("EmapaPl", 0, 19, "png", MapSource.TileUpdate.None);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://mapa.emapa.pl/mapsrc/img.aspx?&x=" + tilex + "&y=" + tiley + "&zoom=" + zoom;
        }

        @Override
        public String toString() {
            return "Emapa.pl (Poland only)";
        }
    }

    public static class FreemapSlovakiaHiking
    extends AbstractMapSource {
        public FreemapSlovakiaHiking() {
            super("FreemapSlovakiaHiking", 6, 16, "png", MapSource.TileUpdate.ETag);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://www.freemap.sk/layers/allinone/?/BNTNp/" + zoom + "/" + tilex + "/" + tiley;
        }

        @Override
        public String toString() {
            return "Freemap Slovakia Hiking";
        }
    }

    public static class FreemapSlovakiaHikingHillShade
    extends AbstractMapSource {
        public FreemapSlovakiaHikingHillShade() {
            super("FreemapSlovakiaHikingHillShade", 6, 16, "png", MapSource.TileUpdate.ETag);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://www.freemap.sk/layers/allinone/?/BVRNTp/" + zoom + "/" + tilex + "/" + tiley;
        }

        @Override
        public String toString() {
            return "Freemap Slovakia Hiking (with HillShade)";
        }
    }

    public static class FreemapSlovakia
    extends AbstractMapSource {
        public FreemapSlovakia() {
            super("FreemapSlovakia", 5, 16, "png", MapSource.TileUpdate.ETag);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://www.freemap.sk/layers/allinone/?/BNp/" + zoom + "/" + tilex + "/" + tiley;
        }

        @Override
        public String toString() {
            return "Freemap Slovakia (Atlas)";
        }
    }

    public static class AustrianMap
    extends AbstractMapSource {
        public AustrianMap() {
            super("AustrianMap", 14, 15, "png");
            this.tileUpdate = MapSource.TileUpdate.ETag;
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            int tileX100 = tilex / 100;
            return "http://www.bergfex.at/images/amap/" + zoom + "/" + tileX100 + "/" + zoom + "_" + tilex + "_" + tiley + ".png";
        }

        @Override
        public String toString() {
            return this.getName() + " (Austria only)";
        }
    }

    public static class Cykloatlas
    extends AbstractMapSource {
        public Cykloatlas() {
            super("Cykloatlas", 7, 15, "png", MapSource.TileUpdate.LastModified);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String z = Integer.toString(zoom);
            if (zoom >= 13) {
                z = z + "c";
            }
            return "http://services.tmapserver.cz/tiles/gm/shc/" + z + "/" + tilex + "/" + tiley + ".png";
        }

        @Override
        public String toString() {
            return this.getName() + " (CZ, SK)";
        }
    }

    public static class OutdooractiveAustria
    extends OutdooractiveGermany {
        public OutdooractiveAustria() {
            this.name = "OutdooractiveAustria";
            this.mapName = "austria";
            this.minZoom = 9;
        }

        @Override
        public String toString() {
            return "Outdooractive.com (Austria only)";
        }
    }

    public static class OutdooractiveSouthTyrol
    extends OutdooractiveGermany {
        public OutdooractiveSouthTyrol() {
            this.name = "OutdooractiveSouthTyrol";
            this.mapName = "suedtirol";
            this.minZoom = 9;
        }

        @Override
        public String toString() {
            return "Outdooractive.com (South Tyrol only)";
        }
    }

    public static class OutdooractiveGermany
    extends AbstractMapSource {
        private static int SERVER_NUM = 0;
        protected String mapName = "portal";

        public OutdooractiveGermany() {
            super("Outdooractive.com", 8, 17, "png", MapSource.TileUpdate.LastModified);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            if (zoom < 8) {
                throw new RuntimeException("Zoom level not suported");
            }
            String s = "http://t" + SERVER_NUM + ".outdooractive.com/" + this.mapName + "/map/" + zoom + "/" + tilex + "/" + tiley + ".png";
            SERVER_NUM = (SERVER_NUM + 1) % 4;
            return s;
        }

        @Override
        public String toString() {
            return "Outdooractive.com (Germany only)";
        }
    }

    public static class UmpWawPl
    extends AbstractMapSource {
        private static int SERVER_NUM = 0;

        public UmpWawPl() {
            super("UMP-pcPL", 0, 18, "png", MapSource.TileUpdate.LastModified);
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String s = "http://" + SERVER_NUM + ".tiles.ump.waw.pl/ump_tiles/" + zoom + "/" + tilex + "/" + tiley + ".png";
            SERVER_NUM = (SERVER_NUM + 1) % 4;
            return s;
        }

        @Override
        public String toString() {
            return this.getName() + " (Poland only)";
        }
    }

    public static class DoCeluPL
    extends AbstractMapSource
    implements UpdatableMapSource {
        private String baseUrl;

        public DoCeluPL() {
            super("DoCeluPL", 2, 16, "png", MapSource.TileUpdate.LastModified);
            this.update();
        }

        @Override
        public void update() {
            this.baseUrl = MapSourceTools.loadMapUrl(this, "baseurl");
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            String sx = String.format("%06x", tilex);
            String sy = String.format("%06x", tiley);
            char[] cx = sx.toCharArray();
            char[] cy = sy.toCharArray();
            String szoom = Integer.toHexString(zoom);
            String s = this.baseUrl + szoom + "/" + cx[4] + cy[4] + "/" + cx[3] + cy[3] + "/" + cx[2] + cy[2] + "/" + cx[1] + cy[1] + "/" + cx[0] + cy[0] + "/z" + szoom + "x" + sx + "y" + sy + ".png";
            return s;
        }

        @Override
        public String toString() {
            return "Docelu.pl (Poland only)";
        }
    }
}

