/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapDownloadSkippedException;
import mobac.gui.AtlasProgress;
import mobac.program.JobDispatcher;
import mobac.program.PauseResumeHandler;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.download.DownloadJobProducerThread;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.DownloadableElement;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStore;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.tar.TarIndex;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;

public class AtlasThread
extends Thread
implements AtlasProgress.AtlasCreationController,
DownloadJobListener {
    private static int threadNum = 0;
    private static Logger log = Logger.getLogger(AtlasThread.class);
    private DownloadJobProducerThread djp = null;
    private JobDispatcher downloadJobDispatcher;
    private AtlasProgress ap = new AtlasProgress(this);
    private AtlasInterface atlasInterface;
    private AtlasCreator atlasCreator = null;
    private PauseResumeHandler pauseResumeHandler;
    private int activeDownloads = 0;
    private int jobsCompleted = 0;
    private int jobsRetryError = 0;
    private int jobsPermanentError = 0;

    public AtlasThread(AtlasInterface atlasInterface) throws AtlasTestException {
        super("AtlasThread " + AtlasThread.getNextThreadNum());
        this.atlasInterface = atlasInterface;
        this.atlasCreator = atlasInterface.getOutputFormat().createAtlasCreatorInstance();
        this.testAtlas();
        TileStore.getInstance().closeAll(false);
        this.pauseResumeHandler = new PauseResumeHandler();
    }

    private void testAtlas() throws AtlasTestException {
        try {
            for (LayerInterface layer : this.atlasInterface) {
                for (MapInterface map : layer) {
                    if (this.atlasCreator.testMapSource(map.getMapSource())) continue;
                    throw new AtlasTestException("The selected atlas output format \"" + (Object)((Object)this.atlasInterface.getOutputFormat()) + "\" does not support the map source \"" + map.getMapSource() + "\"");
                }
            }
        }
        catch (AtlasTestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AtlasTestException(e);
        }
    }

    private static synchronized int getNextThreadNum() {
        return ++threadNum;
    }

    @Override
    public void run() {
        GUIExceptionHandler.registerForCurrentThread();
        log.info("Starting altas creation");
        this.ap.setDownloadControlerListener(this);
        try {
            this.createAtlas();
            log.info("Altas creation finished");
        }
        catch (OutOfMemoryError e) {
            System.gc();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Mobile Atlas Creator has run out of memory.\nPlease make sure you have started it via the provided startup scripts 'start.cmd' (Windows) / 'start.sh' (Linux).\nThose scripts are increasing the maximum memory usable by Mobile Atlas Creator to 512 MB.", "Out of memory", 0);
                    AtlasThread.this.ap.closeWindow();
                }
            });
            log.error("Out of memory: ", e);
        }
        catch (InterruptedException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Atlas download aborted", "Information", 1);
                    AtlasThread.this.ap.closeWindow();
                }
            });
            log.info("Altas creation was interrupted by user");
        }
        catch (Exception e) {
            log.error("Altas creation aborted because of an error: ", e);
            GUIExceptionHandler.showExceptionDialog(e);
        }
        System.gc();
    }

    protected void createAtlas() throws InterruptedException, IOException {
        long totalNrOfTiles = this.atlasInterface.calculateTilesToDownload();
        if (totalNrOfTiles > Integer.MAX_VALUE) {
            JOptionPane.showMessageDialog(null, "The number of tiles to download is too high!", "Error", 0);
            return;
        }
        try {
            this.atlasCreator.startAtlasCreation(this.atlasInterface);
        }
        catch (AtlasTestException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Atlas format restriction violated", 0);
            return;
        }
        this.ap.initAtlas(this.atlasInterface);
        this.ap.setVisible(true);
        Settings s = Settings.getInstance();
        this.downloadJobDispatcher = new JobDispatcher(s.downloadThreadCount, this.pauseResumeHandler);
        try {
            for (LayerInterface layer : this.atlasInterface) {
                this.atlasCreator.initLayerCreation(layer);
                for (MapInterface map : layer) {
                    try {
                        while (!this.createMap(map)) {
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (MapDownloadSkippedException e) {
                    }
                    catch (Exception e) {
                        log.error("", e);
                        Object[] options = new String[]{"Continue", "Abort", "Show error report"};
                        int a = JOptionPane.showOptionDialog(null, "An error occured: " + e.getMessage() + "\n[" + e.getClass().getSimpleName() + "]\n\n", "Error", 0, 0, null, options, options[0]);
                        switch (a) {
                            case 2: {
                                GUIExceptionHandler.processException(e);
                            }
                            case 1: {
                                throw new InterruptedException();
                            }
                        }
                    }
                }
                this.atlasCreator.finishLayerCreation();
            }
        }
        catch (InterruptedException e) {
            this.atlasCreator.abortAtlasCreation();
            throw e;
        }
        catch (Error e) {
            this.atlasCreator.abortAtlasCreation();
            throw e;
        }
        finally {
            if (this.djp != null) {
                this.djp.cancel();
            }
            this.downloadJobDispatcher.terminateAllWorkerThreads();
            if (!this.atlasCreator.isAborted()) {
                this.atlasCreator.finishAtlasCreation();
            }
            this.ap.atlasCreationFinished();
        }
    }

    public boolean createMap(MapInterface map) throws Exception {
        TarIndex tileIndex = null;
        TarIndexedArchive tileArchive = null;
        this.jobsCompleted = 0;
        this.jobsRetryError = 0;
        this.jobsPermanentError = 0;
        this.ap.initMapDownload(map);
        if (AtlasThread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        int zoom = map.getZoom();
        int tileCount = map.calculateTilesToDownload();
        this.ap.setZoomLevel(zoom);
        try {
            tileArchive = null;
            String tempSuffix = "MOBAC_" + this.atlasInterface.getName() + "_" + zoom + "_";
            File tileArchiveFile = File.createTempFile(tempSuffix, ".tar");
            tileArchiveFile.deleteOnExit();
            log.debug("Writing downloaded tiles to " + tileArchiveFile.getPath());
            tileArchive = new TarIndexedArchive(tileArchiveFile, tileCount);
            this.djp = new DownloadJobProducerThread(this, this.downloadJobDispatcher, tileArchive, (DownloadableElement)((Object)map));
            boolean failedMessageAnswered = false;
            block11: while (this.djp.isAlive() || this.downloadJobDispatcher.getWaitingJobCount() > 0 || this.downloadJobDispatcher.isAtLeastOneWorkerActive()) {
                Thread.sleep(500L);
                if (failedMessageAnswered || this.jobsRetryError <= 50 || this.ap.ignoreDownloadErrors()) continue;
                this.pauseResumeHandler.pause();
                Object[] answers = new String[]{"Continue", "Retry", "Skip", "Abort"};
                String message = "<html>Multiple tile downloads have failed. Something may be wrong with your connection to the download server or your selected area. <br>Do you want to:<br><br><u>Continue</u> map download and ignore the errors? (results in blank/missing tiles)<br><u>Retry</u> to download this map, by starting over?<br><u>Skip</u> the current map and continue to process other maps in the atlas?<br><u>Abort</u> the current map and atlas creation process?<br></html>";
                int answer = JOptionPane.showOptionDialog(this.ap, message, "Multiple download errors - how to proceed?", 0, 3, null, answers, answers[0]);
                failedMessageAnswered = true;
                switch (answer) {
                    case 0: {
                        this.pauseResumeHandler.resume();
                        continue block11;
                    }
                    case 1: {
                        this.djp.cancel();
                        this.djp = null;
                        this.downloadJobDispatcher.cancelOutstandingJobs();
                        boolean bl = false;
                        return bl;
                    }
                    case 2: {
                        this.downloadJobDispatcher.cancelOutstandingJobs();
                        throw new MapDownloadSkippedException();
                    }
                }
                this.downloadJobDispatcher.cancelOutstandingJobs();
                this.downloadJobDispatcher.terminateAllWorkerThreads();
                throw new InterruptedException();
            }
            this.djp = null;
            log.debug("All download jobs has been completed!");
            tileArchive.writeEndofArchive();
            tileArchive.close();
            tileIndex = tileArchive.getTarIndex();
            if (tileIndex.size() < tileCount && !this.ap.ignoreDownloadErrors()) {
                int missing = tileCount - tileIndex.size();
                log.debug("Expected tile count: " + tileCount + " downloaded tile count: " + tileIndex.size() + " missing: " + missing);
                int answer = JOptionPane.showConfirmDialog(this.ap, "Something is wrong with download of atlas tiles.\nThe amount of downladed tiles is not as high as it was calculated.\nTherfore tiles will be missing in the created atlas.\n" + missing + " tiles are missing.\n\n" + "Are you sure you want to continue " + "and create the atlas anyway?", "Error - tiles are missing - do you want to continue anyway?", 1, 0);
                if (answer != 0) {
                    throw new InterruptedException();
                }
            }
            this.downloadJobDispatcher.cancelOutstandingJobs();
            log.debug("Starting to create atlas from downloaded tiles");
            this.atlasCreator.initializeMap(map, tileIndex);
            this.atlasCreator.createMap();
        }
        catch (Error e) {
            log.error("Error in createMap: " + e.getMessage(), e);
            throw e;
        }
        finally {
            if (tileIndex != null) {
                tileIndex.closeAndDelete();
            } else if (tileArchive != null) {
                tileArchive.delete();
            }
        }
        return true;
    }

    @Override
    public void pauseResumeAtlasCreation() {
        if (this.pauseResumeHandler.isPaused()) {
            log.debug("Atlas creation resumed");
            this.pauseResumeHandler.resume();
        } else {
            log.debug("Atlas creation paused");
            this.pauseResumeHandler.pause();
        }
    }

    public boolean isPaused() {
        return this.pauseResumeHandler.isPaused();
    }

    public PauseResumeHandler getPauseResumeHandler() {
        return this.pauseResumeHandler;
    }

    @Override
    public void abortAtlasCreation() {
        try {
            DownloadJobProducerThread djp_ = this.djp;
            if (djp_ != null) {
                djp_.cancel();
            }
            if (this.downloadJobDispatcher != null) {
                this.downloadJobDispatcher.terminateAllWorkerThreads();
            }
            this.pauseResumeHandler.resume();
            this.interrupt();
        }
        catch (Exception e) {
            log.error("Exception thrown in stopDownload()" + e.getMessage());
        }
    }

    public int getActiveDownloads() {
        return this.activeDownloads;
    }

    @Override
    public synchronized void jobStarted() {
        ++this.activeDownloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinishedSuccessfully(int bytesDownloaded) {
        AtlasThread atlasThread = this;
        synchronized (atlasThread) {
            this.ap.addDownloadedBytes(bytesDownloaded);
            this.ap.incMapDownloadProgress();
            --this.activeDownloads;
            ++this.jobsCompleted;
        }
        this.ap.updateGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobFinishedWithError(boolean retry) {
        AtlasThread atlasThread = this;
        synchronized (atlasThread) {
            --this.activeDownloads;
            if (retry) {
                ++this.jobsRetryError;
            } else {
                ++this.jobsPermanentError;
                this.ap.incMapDownloadProgress();
            }
        }
        if (!this.ap.ignoreDownloadErrors()) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.ap.setErrorCounter(this.jobsRetryError, this.jobsPermanentError);
        this.ap.updateGUI();
    }

    public AtlasProgress getAtlasProgress() {
        return this.ap;
    }
}

