/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.File;
import mobac.utilities.OSUtilities;
import mobac.utilities.Utilities;

public class DirectoryManager {
    public static final File currentDir = new File(System.getProperty("user.dir"));
    public static final File programDir;
    public static final File userHomeDir;
    public static final File userSettingsDir;
    public static final File tempDir;

    public static void initialize() {
        if (currentDir == null || userSettingsDir == null || tempDir == null || programDir == null) {
            throw new RuntimeException("DirectoryManager failed");
        }
    }

    private static File getProgramDir() {
        File file = Utilities.getClassLocation(DirectoryManager.class);
        if ("bin".equals(file.getName())) {
            return file.getParentFile();
        }
        return file;
    }

    private static File getUserSettingsDir() {
        File userDir;
        File mobacUserDir;
        if (OSUtilities.detectOs() == OSUtilities.OperatingSystem.Windows) {
            String appData = System.getenv("APPDATA");
            if (appData == null) {
                throw new RuntimeException("User application data to found");
            }
            File appDataDir = new File(appData);
            if (appDataDir.isDirectory()) {
                File mobacDataDir = new File(appData, "Mobile Atlas Creator");
                if (mobacDataDir.isDirectory() || mobacDataDir.mkdir()) {
                    return mobacDataDir;
                }
                throw new RuntimeException("Unable to create directory \"" + mobacDataDir.getAbsolutePath() + "\"");
            }
        }
        if (!(mobacUserDir = new File(userDir = new File(System.getProperty("user.home")), ".mobac")).exists() && !mobacUserDir.mkdir()) {
            throw new RuntimeException("Unable to create directory \"" + mobacUserDir.getAbsolutePath() + "\"");
        }
        return mobacUserDir;
    }

    static {
        userHomeDir = new File(System.getProperty("user.home"));
        userSettingsDir = DirectoryManager.getUserSettingsDir();
        tempDir = new File(System.getProperty("java.io.tmpdir"));
        programDir = DirectoryManager.getProgramDir();
    }
}

