/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import mobac.program.PauseResumeHandler;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import org.apache.log4j.Logger;

public class JobDispatcher {
    private static Logger log = Logger.getLogger(JobDispatcher.class);
    protected int maxJobsInQueue = 100;
    protected int minJobsInQueue = 50;
    protected WorkerThread[] workers;
    protected PauseResumeHandler pauseResumeHandler;
    protected BlockingQueue<Job> jobQueue = new LinkedBlockingQueue<Job>();

    public JobDispatcher(int threadCount, PauseResumeHandler pauseResumeHandler) {
        this.pauseResumeHandler = pauseResumeHandler;
        this.workers = new WorkerThread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            this.workers[i] = new WorkerThread(i);
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAllWorkerThreads();
        super.finalize();
    }

    public void terminateAllWorkerThreads() {
        this.cancelOutstandingJobs();
        log.trace("Killing all worker threads");
        for (int i = 0; i < this.workers.length; ++i) {
            try {
                WorkerThread w = this.workers[i];
                if (w != null) {
                    w.interrupt();
                }
                this.workers[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    public void addJob(Job job) throws InterruptedException {
        while (this.jobQueue.size() > this.maxJobsInQueue) {
            Thread.sleep(200L);
            if (this.jobQueue.size() >= this.minJobsInQueue || this.maxJobsInQueue >= 2000) continue;
            this.maxJobsInQueue *= 2;
            this.minJobsInQueue *= 2;
        }
        this.jobQueue.put(job);
    }

    public void addErrorJob(Job job) {
        try {
            this.jobQueue.put(job);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getWaitingJobCount() {
        return this.jobQueue.size();
    }

    public boolean isAtLeastOneWorkerActive() {
        for (int i = 0; i < this.workers.length; ++i) {
            WorkerThread w = this.workers[i];
            if (w == null || w.idle || w.getState() == Thread.State.WAITING) continue;
            return true;
        }
        log.debug("All worker threads are idle");
        return false;
    }

    protected class WorkerThread
    extends DelayedInterruptThread {
        Job job;
        boolean idle;
        private Logger log;

        public WorkerThread(int n) {
            super(String.format("WorkerThread %02d", n));
            this.job = null;
            this.idle = true;
            this.log = Logger.getLogger(WorkerThread.class);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                this.executeJobs();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.trace("Thread is terminating");
        }

        protected void executeJobs() throws InterruptedException {
            while (!this.isInterrupted()) {
                try {
                    JobDispatcher.this.pauseResumeHandler.pauseWait();
                    this.idle = true;
                    this.job = JobDispatcher.this.jobQueue.take();
                    this.idle = false;
                }
                catch (InterruptedException e1) {
                    return;
                }
                if (this.job == null) {
                    return;
                }
                try {
                    this.job.run(JobDispatcher.this);
                    this.job = null;
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        return;
                    }
                    this.log.error("Unknown error occured while executing the job: ", e);
                }
                catch (OutOfMemoryError e) {
                    this.log.error("", e);
                    Thread.sleep(5000L);
                    System.gc();
                }
            }
        }
    }

    public static interface Job {
        public void run(JobDispatcher var1) throws Exception;
    }
}

