/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.File;
import mobac.program.DirectoryManager;
import mobac.program.ProgramInfo;
import mobac.utilities.GUIExceptionHandler;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class Logging {
    protected static File CONFIG_FILE = null;
    public static final Logger LOG = Logger.getLogger("MAC");
    public static final Layout ADVANCED_LAYOUT = new PatternLayout("%d{ISO8601} %-5p [%t] %c{1}: %m%n");

    public static void configureLogging() {
        if (!Logging.loadLog4JConfigXml()) {
            Logging.configureDefaultErrorLogging();
            Logger logger = Logger.getRootLogger();
            logger.info("log4.xml not found - enabling default error log to console");
        }
    }

    public static boolean loadLog4JConfigXml() {
        if (Logging.loadLog4JConfigXml(DirectoryManager.userSettingsDir)) {
            return true;
        }
        if (Logging.loadLog4JConfigXml(DirectoryManager.currentDir)) {
            return true;
        }
        return Logging.loadLog4JConfigXml(DirectoryManager.programDir);
    }

    public static boolean loadLog4JConfigXml(File directory) {
        File f = new File(directory, "log4j.xml");
        if (!f.isFile()) {
            return false;
        }
        try {
            DOMConfigurator.configure(f.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Error loading log4j config file \"" + f.getAbsolutePath() + "\"");
            return false;
        }
        Logger logger = Logger.getLogger("LogSystem");
        logger.setLevel(Level.INFO);
        logger.info("Logging configured by \"" + f.getAbsolutePath() + "\"");
        return true;
    }

    public static void configureDefaultErrorLogging() {
        Logging.configureConsoleLogging(Level.INFO, new SimpleLayout());
        Logging.configureLogfileLogging(Level.WARN);
    }

    public static void configureConsoleLogging(Level level, Layout layout) {
        Logger logger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = new ConsoleAppender(layout);
        consoleAppender.setThreshold(level);
        logger.addAppender(consoleAppender);
    }

    public static void configureLogfileLogging(Level level) {
        Logger logger = Logger.getRootLogger();
        File logFileDir = DirectoryManager.userSettingsDir;
        String logFilename = new File(logFileDir, "Mobile Atlas Creator.log").getAbsolutePath();
        PatternLayout layout = new PatternLayout("%d{ISO8601} %-5p [%t] %c{1}: %m%n");
        try {
            FileAppender consoleAppender = new FileAppender(layout, logFilename, false);
            consoleAppender.setThreshold(level);
            logger.addAppender(consoleAppender);
        }
        catch (Exception e) {
            Logger log = Logger.getLogger("LogSystem");
            log.error("", e);
        }
    }

    public static void logSystemInfo() {
        Logger log = Logger.getLogger("SysInfo");
        if (!log.isInfoEnabled()) {
            return;
        }
        String n = System.getProperty("line.separator");
        log.debug("Version: " + ProgramInfo.getCompleteTitle());
        log.debug("Platform: " + GUIExceptionHandler.prop("os.name") + " (" + GUIExceptionHandler.prop("os.version") + ")");
        log.debug("Java VM: " + GUIExceptionHandler.prop("java.vm.name") + " (" + GUIExceptionHandler.prop("java.runtime.version") + ")");
        log.debug("Directories:" + n + "currentDir: \t" + DirectoryManager.currentDir + n + "programDir: \t" + DirectoryManager.programDir + n + "tempDir:     \t" + DirectoryManager.tempDir + n + "userHomeDir: \t" + DirectoryManager.userHomeDir + n + "userSettingsDir: \t" + DirectoryManager.userSettingsDir);
    }
}

