/*
 * Decompiled with CFR 0.152.
 */
package mobac.program;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import mobac.Main;
import mobac.program.Logging;
import mobac.utilities.Utilities;

public class ProgramInfo {
    public static String PROG_NAME = "Mobile Atlas Creator";
    private static String version = null;
    private static String revision = "";
    private static boolean titleHideRevision = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Properties properties;
        InputStream inputStream = Main.class.getResourceAsStream("mobac.properties");
        try {
            properties = new Properties();
            properties.load(inputStream);
            version = properties.getProperty("mobac.version");
            titleHideRevision = Boolean.parseBoolean(properties.getProperty("mobac.revision.hide", "false"));
            System.getProperties().putAll((Map<?, ?>)properties);
        }
        catch (Exception exception) {
            Logging.LOG.error("Error reading mobac.properties", exception);
        }
        finally {
            Utilities.closeStream(inputStream);
        }
        inputStream = Main.class.getResourceAsStream("mobac-rev.properties");
        try {
            properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("mobac.revision");
            revision = "(" + string + ")";
        }
        catch (Exception exception) {
            Logging.LOG.error("Error reading mobac-rev.properties", exception);
        }
        finally {
            Utilities.closeStream(inputStream);
        }
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        return "UNKNOWN";
    }

    public static String getVersionTitle() {
        String title = version != null ? PROG_NAME + " " + version : PROG_NAME + " unknown version";
        return title;
    }

    public static String getCompleteTitle() {
        String title = ProgramInfo.getVersionTitle();
        if (!titleHideRevision) {
            title = title + " " + revision;
        }
        return title;
    }
}

