/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class AndNav
extends AtlasCreator {
    private File mapZoomDir = null;
    protected String additionalFileExt = ".andnav";
    protected String tileType = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
        File mapDir = new File(this.atlasDir, map.getMapSource().getName());
        this.mapZoomDir = new File(mapDir, Integer.toString(map.getZoom()));
        this.tileType = this.mapSource.getTileType();
        if (this.parameters != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
            this.tileType = this.parameters.getFormat().getDataWriter().getFileExt();
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.mapZoomDir);
        }
        catch (IOException e) {
            throw new MapCreationException(e);
        }
        this.createTiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        for (int x = this.xMin; x <= this.xMax; ++x) {
            File xDir = new File(this.mapZoomDir, Integer.toString(x));
            try {
                Utilities.mkDir(xDir);
            }
            catch (IOException e1) {
                throw new MapCreationException(e1);
            }
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    String tileFileName = x + "/" + y + "." + this.tileType + this.additionalFileExt;
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    File f = new File(this.mapZoomDir, tileFileName);
                    FileOutputStream out = new FileOutputStream(f);
                    try {
                        out.write(sourceTileData);
                        continue;
                    }
                    finally {
                        Utilities.closeStream(out);
                    }
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), e);
                }
            }
        }
    }
}

