/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.gui.AtlasProgress;
import mobac.mapsources.MultiLayerMapSource;
import mobac.program.AtlasThread;
import mobac.program.PauseResumeHandler;
import mobac.program.atlascreators.tileprovider.DownloadedTileProvider;
import mobac.program.atlascreators.tileprovider.MultiLayerTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarIndex;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public abstract class AtlasCreator {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected AtlasInterface atlas;
    protected File atlasDir;
    protected AtlasProgress atlasProgress = null;
    protected PauseResumeHandler pauseResumeHandler = null;
    protected MapInterface map;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected TarIndex tarTileIndex;
    protected int zoom;
    protected AtlasOutputFormat atlasOutputFormat;
    protected MapSource mapSource;
    protected int tileSize;
    protected TileImageParameters parameters;
    protected TileProvider mapDlTileProvider;
    private boolean aborted = false;

    protected AtlasCreator() {
    }

    public void startAtlasCreation(AtlasInterface atlas) throws AtlasTestException, IOException, InterruptedException {
        this.atlas = atlas;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String atlasDirName = atlas.getName() + "_" + sdf.format(new Date());
        File atlasOutputDir = Settings.getInstance().getAtlasOutputDirectory();
        this.atlasDir = new File(atlasOutputDir, atlasDirName);
        Utilities.mkDirs(this.atlasDir);
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
    }

    public void finishLayerCreation() throws IOException {
    }

    public void finishAtlasCreation() throws IOException, InterruptedException {
    }

    public void abortAtlasCreation() throws IOException {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public abstract boolean testMapSource(MapSource var1);

    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        Thread t;
        LayerInterface layer = map.getLayer();
        this.map = map;
        this.mapSource = map.getMapSource();
        this.tileSize = this.mapSource.getMapSpace().getTileSize();
        this.parameters = map.getParameters();
        this.xMin = map.getMinTileCoordinate().x / this.tileSize;
        this.xMax = map.getMaxTileCoordinate().x / this.tileSize;
        this.yMin = map.getMinTileCoordinate().y / this.tileSize;
        this.yMax = map.getMaxTileCoordinate().y / this.tileSize;
        this.tarTileIndex = tarTileIndex;
        this.zoom = map.getZoom();
        this.atlasOutputFormat = layer.getAtlas().getOutputFormat();
        this.mapDlTileProvider = new DownloadedTileProvider(tarTileIndex, this.mapSource);
        if (map.getMapSource() instanceof MultiLayerMapSource) {
            this.mapDlTileProvider = new MultiLayerTileProvider(map.getMapSource(), this.mapDlTileProvider, 2);
        }
        if (!((t = Thread.currentThread()) instanceof AtlasThread)) {
            throw new RuntimeException("Calling thread must be AtlasThread!");
        }
        AtlasThread at = (AtlasThread)t;
        this.atlasProgress = at.getAtlasProgress();
        this.pauseResumeHandler = at.getPauseResumeHandler();
    }

    public abstract void createMap() throws MapCreationException, InterruptedException;

    public void checkUserAbort() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        this.pauseResumeHandler.pauseWait();
    }

    public AtlasProgress getAtlasProgress() {
        return this.atlasProgress;
    }

    public int getXMin() {
        return this.xMin;
    }

    public int getXMax() {
        return this.xMax;
    }

    public int getYMin() {
        return this.yMin;
    }

    public int getYMax() {
        return this.yMax;
    }

    public MapInterface getMap() {
        return this.map;
    }

    public TileImageParameters getParameters() {
        return this.parameters;
    }

    public TileProvider getMapDlTileProvider() {
        return this.mapDlTileProvider;
    }
}

