/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.MultiLayerMapSource;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.Settings;
import mobac.utilities.Utilities;
import mobac.utilities.jdbc.SQLiteLoader;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class BigPlanetSql
extends AtlasCreator {
    private String databaseFile;
    private Connection conn = null;
    private PreparedStatement prepStmt;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        if (mapSource instanceof MultiLayerMapSource) {
            return false;
        }
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas) throws IOException {
        this.atlas = atlas;
        this.atlasDir = Settings.getInstance().getAtlasOutputDirectory();
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
        this.databaseFile = new File(this.atlasDir, "BigPlanet_maps.sqlitedb").getAbsolutePath();
        this.log.debug("SQLite Database file: " + this.databaseFile);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.atlasDir);
        }
        catch (IOException e) {
            throw new MapCreationException(e);
        }
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new MapCreationException("Unable to find the SQLite libraries. These are required for BigPlanet output format.<br>Please read the README.HTM section \"Creating and using atlases with BigPlanet / RMaps\". ", e);
        }
        try {
            this.initializeDB();
            this.createTiles();
            this.conn.close();
        }
        catch (SQLException e) {
            throw new MapCreationException("Error creating SQL database \"" + this.databaseFile + "\": " + e.getMessage(), e);
        }
    }

    private Connection getConnection() throws SQLException {
        String url = "jdbc:sqlite:/" + this.databaseFile;
        Connection conn = DriverManager.getConnection(url);
        return conn;
    }

    private void initializeDB() throws SQLException {
        this.conn = this.getConnection();
        Statement stat = this.conn.createStatement();
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS tiles (x int, y int, z int, s int, image blob, PRIMARY KEY (x,y,z,s))");
        stat.executeUpdate("CREATE INDEX IF NOT EXISTS IND on tiles (x,y,z,s)");
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS info AS SELECT 99 As minzoom, 0 As maxzoom");
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)");
        if (!stat.executeQuery("SELECT * FROM android_metadata").first()) {
            String locale = Locale.getDefault().toString();
            stat.executeUpdate("INSERT INTO android_metadata VALUES ('" + locale + "')");
        }
        stat.close();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation(2 * (this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        try {
            this.conn.setAutoCommit(false);
            int batchTileCount = 0;
            Runtime r = Runtime.getRuntime();
            long heapMaxSize = r.maxMemory();
            this.prepStmt = this.conn.prepareStatement("INSERT or IGNORE INTO tiles (x,y,z,s,image) VALUES (?,?,?,?,?)");
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData == null) continue;
                        this.writeTile(x, y, this.zoom, sourceTileData);
                        long heapAvailable = heapMaxSize - r.totalMemory() + r.freeMemory();
                        ++batchTileCount;
                        if (heapAvailable >= 0x500000L) continue;
                        this.log.trace("Batch commited containing " + batchTileCount + " tiles");
                        this.prepStmt.executeBatch();
                        this.prepStmt.clearBatch();
                        this.atlasProgress.incMapCreationProgress(batchTileCount);
                        batchTileCount = 0;
                        this.conn.commit();
                        System.gc();
                        continue;
                    }
                    catch (IOException e) {
                        throw new MapCreationException(e);
                    }
                }
            }
            this.prepStmt.executeBatch();
            this.conn.commit();
            this.prepStmt.clearBatch();
            this.atlasProgress.incMapCreationProgress(batchTileCount);
            Statement stat = this.conn.createStatement();
            stat.addBatch("DELETE FROM info");
            stat.addBatch("INSERT INTO info SELECT MIN(z) as minzoom, MAX(z) as maxzoom FROM tiles");
            stat.executeBatch();
            stat.close();
            this.conn.commit();
        }
        catch (SQLException e) {
            this.log.error("", e);
        }
    }

    private void writeTile(int x, int y, int z, byte[] tileData) throws SQLException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(tileData);
        int s = 0;
        this.prepStmt.setInt(1, x);
        this.prepStmt.setInt(2, y);
        this.prepStmt.setInt(3, 17 - z);
        this.prepStmt.setInt(4, s);
        this.prepStmt.setBinaryStream(5, (InputStream)is, ((InputStream)is).available());
        this.prepStmt.addBatch();
        ((InputStream)is).close();
    }
}

