/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.TileImageFormat;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ArrayOutputStream;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GarminCustom
extends AtlasCreator {
    protected File mapDir;
    protected String cleanedMapName;
    protected File kmzFile = null;
    protected ZipOutputStream kmzOutputStream = null;
    private CRC32 crc = new CRC32();
    private Document kmlDoc = null;
    private Element groundOverlayRoot = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return mapSource.getMapSpace() instanceof MercatorPower2MapSpace;
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas);
        for (LayerInterface layer : atlas) {
            if (layer.getMapCount() > 100) {
                throw new AtlasTestException("Layer exceeeds the maximum map count of 100", layer);
            }
            for (MapInterface map : layer) {
                TileImageFormat format;
                if (map.getParameters() == null || (format = map.getParameters().getFormat()).getDataWriter() instanceof TileImageJpegDataWriter) continue;
                throw new AtlasTestException("Only JPEG tile format is supported by this atlas format!", map);
            }
        }
    }

    @Override
    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        Utilities.mkDirs(this.atlasDir);
        this.kmzFile = new File(this.atlasDir, layer.getName() + ".kmz");
        this.kmzOutputStream = new ZipOutputStream(new FileOutputStream(this.kmzFile));
        this.kmzOutputStream.setMethod(0);
        try {
            if (layer.getMapCount() <= 1) {
                this.initKmlDoc(null);
            } else {
                this.initKmlDoc(layer.getName());
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void finishLayerCreation() throws IOException {
        try {
            this.writeKmlToZip();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Utilities.closeStream(this.kmzOutputStream);
        this.kmzOutputStream = null;
        this.kmzFile = null;
        super.finishLayerCreation();
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        Utilities.closeStream(this.kmzOutputStream);
        this.kmzOutputStream = null;
        this.kmzFile = null;
        super.abortAtlasCreation();
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
        this.mapDir = new File(this.atlasDir, map.getLayer().getName());
        this.cleanedMapName = map.getName();
        this.cleanedMapName = this.cleanedMapName.replaceAll("[[^\\p{Alnum}-_]]+", "_");
        this.cleanedMapName = this.cleanedMapName.replaceAll("_{2,}", "_");
        if (this.cleanedMapName.endsWith("_")) {
            this.cleanedMapName = this.cleanedMapName.substring(0, this.cleanedMapName.length() - 1);
        }
        if (this.cleanedMapName.startsWith("_")) {
            this.cleanedMapName = this.cleanedMapName.substring(1, this.cleanedMapName.length());
        }
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            String fileName = "files/" + this.cleanedMapName + ".jpg";
            this.createImage(fileName);
            this.addMapToKmz(fileName);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createImage(String imageFileName) throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        int mapWidth = (this.xMax - this.xMin + 1) * this.tileSize;
        int mapHeight = (this.yMax - this.yMin + 1) * this.tileSize;
        int imageWidth = Math.min(1024, mapWidth);
        int imageHeight = Math.min(1024, mapHeight);
        int len = Math.max(mapWidth, mapHeight);
        double scaleFactor = 1.0;
        if (len > 1024) {
            scaleFactor = 1024.0 / (double)len;
            if (mapWidth != mapHeight) {
                if (mapWidth > mapHeight) {
                    imageHeight = (int)(scaleFactor * (double)mapHeight);
                } else {
                    imageWidth = (int)(scaleFactor * (double)mapWidth);
                }
            }
        }
        BufferedImage tileImage = new BufferedImage(imageWidth, imageHeight, 5);
        Graphics2D graphics = tileImage.createGraphics();
        try {
            if (len > 1024) {
                graphics.setTransform(AffineTransform.getScaleInstance(scaleFactor, scaleFactor));
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            int lineY = 0;
            for (int y = this.yMin; y <= this.yMax; ++y) {
                int lineX = 0;
                for (int x = this.xMin; x <= this.xMax; ++x) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData != null) {
                            BufferedImage tile = ImageIO.read(new ByteArrayInputStream(sourceTileData));
                            graphics.drawImage(tile, lineX, lineY, Color.WHITE, null);
                        }
                    }
                    catch (IOException e) {
                        this.log.error("", e);
                    }
                    lineX += this.tileSize;
                }
                lineY += this.tileSize;
            }
        }
        finally {
            graphics.dispose();
        }
        try {
            TileImageJpegDataWriter writer;
            if (this.parameters != null) {
                writer = (TileImageJpegDataWriter)this.parameters.getFormat().getDataWriter();
                writer = new TileImageJpegDataWriter(writer);
            } else {
                writer = new TileImageJpegDataWriter(0.9);
            }
            writer.initialize();
            ArrayOutputStream buf = new ArrayOutputStream(0x300000);
            byte[] data = null;
            for (int c = 99; c > 50; c -= 5) {
                buf.reset();
                try {
                    writer.processImage(tileImage, buf);
                    data = buf.toByteArray();
                    break;
                }
                catch (IOException e) {
                    this.log.trace("Image size too large, increasing compression to " + c);
                    writer.setJpegCompressionLevel((float)c / 100.0f);
                    continue;
                }
            }
            if (data == null) {
                throw new MapCreationException("Unable to create an image with less than 3 MB!");
            }
            this.writeStoredEntry(imageFileName, data);
        }
        catch (IOException e) {
            throw new MapCreationException(e);
        }
    }

    private void writeStoredEntry(String name, byte[] data) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        ze.setMethod(0);
        ze.setCompressedSize(data.length);
        ze.setSize(data.length);
        this.crc.reset();
        this.crc.update(data);
        ze.setCrc(this.crc.getValue());
        this.kmzOutputStream.putNextEntry(ze);
        this.kmzOutputStream.write(data);
        this.kmzOutputStream.closeEntry();
    }

    private void addMapToKmz(String imageFileName) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        int startX = this.xMin * this.tileSize;
        int endX = (this.xMax + 1) * this.tileSize;
        int startY = this.yMin * this.tileSize;
        int endY = (this.yMax + 1) * this.tileSize;
        this.addKmlEntry(this.map.getName(), imageFileName, startX, startY, endX - startX, endY - startY);
    }

    private void initKmlDoc(String folderName) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.kmlDoc = builder.newDocument();
        Element kml = this.kmlDoc.createElementNS("http://www.opengis.net/kml/2.2", "kml");
        this.kmlDoc.appendChild(kml);
        this.groundOverlayRoot = kml;
        if (folderName != null) {
            this.groundOverlayRoot = this.kmlDoc.createElement("Folder");
            kml.appendChild(this.groundOverlayRoot);
            Element name = this.kmlDoc.createElement("name");
            name.setTextContent(folderName);
            Element open = this.kmlDoc.createElement("open");
            open.setTextContent("1");
            this.groundOverlayRoot.appendChild(name);
            this.groundOverlayRoot.appendChild(open);
        }
    }

    private void addKmlEntry(String imageName, String imageFileName, int startX, int startY, int width, int height) {
        Element go = this.kmlDoc.createElement("GroundOverlay");
        Element name = this.kmlDoc.createElement("name");
        Element ico = this.kmlDoc.createElement("Icon");
        Element href = this.kmlDoc.createElement("href");
        Element drawOrder = this.kmlDoc.createElement("drawOrder");
        Element latLonBox = this.kmlDoc.createElement("LatLonBox");
        Element north = this.kmlDoc.createElement("north");
        Element south = this.kmlDoc.createElement("south");
        Element east = this.kmlDoc.createElement("east");
        Element west = this.kmlDoc.createElement("west");
        Element rotation = this.kmlDoc.createElement("rotation");
        name.setTextContent(imageName);
        href.setTextContent(imageFileName);
        drawOrder.setTextContent("0");
        MapSpace mapSpace = this.mapSource.getMapSpace();
        DecimalFormat df = Utilities.FORMAT_6_DEC_ENG;
        String longitudeMin = df.format(mapSpace.cXToLon(startX, this.zoom));
        String longitudeMax = df.format(mapSpace.cXToLon(startX + width, this.zoom));
        String latitudeMin = df.format(mapSpace.cYToLat(startY + height, this.zoom));
        String latitudeMax = df.format(mapSpace.cYToLat(startY, this.zoom));
        north.setTextContent(latitudeMax);
        south.setTextContent(latitudeMin);
        west.setTextContent(longitudeMin);
        east.setTextContent(longitudeMax);
        rotation.setTextContent("0.0");
        this.groundOverlayRoot.appendChild(go);
        go.appendChild(name);
        go.appendChild(ico);
        go.appendChild(latLonBox);
        ico.appendChild(href);
        ico.appendChild(drawOrder);
        latLonBox.appendChild(north);
        latLonBox.appendChild(south);
        latLonBox.appendChild(east);
        latLonBox.appendChild(west);
        latLonBox.appendChild(rotation);
    }

    private void writeKmlToZip() throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16000);
        serializer.transform(new DOMSource(this.kmlDoc), new StreamResult(bos));
        this.writeStoredEntry("doc.kml", bos.toByteArray());
        this.kmlDoc = null;
        this.groundOverlayRoot = null;
    }
}

