/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.rmp.BoundingRect;
import mobac.program.atlascreators.impl.rmp.MultiImage;
import mobac.program.atlascreators.impl.rmp.RmpLayer;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.RmpWriter;
import mobac.program.atlascreators.impl.rmp.Tiledata;
import mobac.program.atlascreators.impl.rmp.rmpfile.Bmp2bit;
import mobac.program.atlascreators.impl.rmp.rmpfile.Bmp4bit;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class MagellanRmp
extends AtlasCreator {
    RmpWriter rmpWriter = null;
    String imageName = null;
    int layerNum = 0;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    @Override
    public void startAtlasCreation(AtlasInterface atlas) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas);
        int mapCount = 0;
        for (LayerInterface layer : atlas) {
            for (MapInterface map : layer) {
                ++mapCount;
                Point max = map.getMaxTileCoordinate();
                Point min = map.getMinTileCoordinate();
                if (max.x - min.x <= 18000 && max.y - min.y <= 18000) continue;
                throw new IOException("Map too large. Max size 18000x18000");
            }
        }
        this.imageName = RmpTools.buildImageName(atlas.getName());
        this.rmpWriter = new RmpWriter(this.imageName, mapCount, new File(this.atlasDir, this.imageName + ".rmp"));
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation(1000);
        ImageIO.setUseCache(false);
        MultiImage layerImage = new MultiImage(this.mapSource, this.mapDlTileProvider, this.map);
        try {
            RmpLayer layer = this.createLayer(layerImage, this.layerNum);
            String layerName = RmpTools.buildTileName(this.imageName, this.layerNum);
            RmpLayer.TLMEntry tlmEntry = layer.getTLMFile(layerName);
            this.rmpWriter.prepareFileEntry(tlmEntry);
            this.rmpWriter.writeFileEntry(layer.getA00File(layerName));
            tlmEntry.updateContent();
            this.rmpWriter.writePreparedFileEntry(tlmEntry);
            this.atlasProgress.setMapCreationProgress(1000);
        }
        catch (IOException e) {
            throw new MapCreationException(e);
        }
        ++this.layerNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAtlasCreation() throws IOException, InterruptedException {
        if (this.rmpWriter == null) {
            return;
        }
        try {
            this.rmpWriter.writeFileEntry(new Bmp2bit());
            this.rmpWriter.writeFileEntry(new Bmp4bit());
            this.rmpWriter.writeDirectory();
        }
        finally {
            this.rmpWriter.close();
            this.rmpWriter = null;
        }
    }

    @Override
    public void abortAtlasCreation() throws IOException {
        super.abortAtlasCreation();
        this.rmpWriter.delete();
        this.rmpWriter = null;
    }

    public RmpLayer createLayer(MultiImage si, int layer) throws InterruptedException, MapCreationException, IOException {
        int count = 0;
        RmpLayer rmpLayer = new RmpLayer(this);
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double north = mapSpace.cYToLat(this.map.getMinTileCoordinate().y, this.zoom);
        double south = mapSpace.cYToLat(this.map.getMaxTileCoordinate().y, this.zoom);
        double west = mapSpace.cXToLon(this.map.getMinTileCoordinate().x, this.zoom);
        double east = mapSpace.cXToLon(this.map.getMaxTileCoordinate().x, this.zoom);
        BoundingRect rect = new BoundingRect(-north, -south, west, east);
        Point max = this.map.getMaxTileCoordinate();
        Point min = this.map.getMinTileCoordinate();
        int imageWidth = max.x - min.x;
        int imageHeight = max.y - min.y;
        double tile_width = (rect.getEast() - rect.getWest()) * 256.0 / (double)imageWidth;
        double tile_height = (rect.getSouth() - rect.getNorth()) * 256.0 / (double)imageHeight;
        int x_start = (int)Math.floor((rect.getWest() + 180.0) / tile_width);
        int y_start = (int)Math.floor((rect.getNorth() + 90.0) / tile_height);
        double x_end = (rect.getEast() + 180.0) / tile_width;
        double y_end = (rect.getSouth() + 90.0) / tile_height;
        int x = x_start;
        while ((double)x < x_end) {
            int y = y_start;
            while ((double)y < y_end) {
                ++count;
                BoundingRect subrect = new BoundingRect((double)y * tile_height - 90.0, (double)(y + 1) * tile_height - 90.0, (double)x * tile_width - 180.0, (double)(x + 1) * tile_width - 180.0);
                Tiledata td = new Tiledata();
                td.posx = x;
                td.posy = y++;
                td.rect = subrect;
                td.si = si;
                rmpLayer.addPreparedImage(td);
            }
            ++x;
        }
        rmpLayer.buildTLMFile(tile_width, tile_height, rect.getWest(), rect.getEast(), rect.getNorth(), rect.getSouth());
        return rmpLayer;
    }
}

