/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.TrekBuddy;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.Utilities;
import mobac.utilities.imageio.PngXxlWriter;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class Ozi
extends TrekBuddy {
    protected File mapDir = null;
    protected String mapName = null;

    @Override
    public boolean testMapSource(MapSource mapSource) {
        return mapSource.getMapSpace() instanceof MercatorPower2MapSpace;
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
        this.mapDir = new File(this.atlasDir, map.getLayer().getName());
        this.mapName = map.getName();
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.mapDir);
        }
        catch (IOException e) {
            throw new MapCreationException(e);
        }
        this.createTiles();
        this.writeMapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeMapFile() {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.mapDir, this.mapName + ".map"));
            this.writeMapFile(this.map.getName() + ".png", fout);
            Utilities.closeStream(fout);
        }
        catch (Exception e) {
            this.log.error("", e);
        }
        finally {
            Utilities.closeStream(fout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        int tileLineHeight = this.tileSize;
        FileOutputStream fileOs = null;
        try {
            fileOs = new FileOutputStream(new File(this.mapDir, this.mapName + ".png"));
            PngXxlWriter pngWriter = new PngXxlWriter(width, height, fileOs);
            for (int y = this.yMin; y <= this.yMax; ++y) {
                BufferedImage lineImage = new BufferedImage(width, tileLineHeight, 1);
                Graphics2D graphics = lineImage.createGraphics();
                try {
                    graphics.setColor(this.mapSource.getBackgroundColor());
                    graphics.fillRect(0, 0, width, tileLineHeight);
                    int lineX = 0;
                    for (int x = this.xMin; x <= this.xMax; ++x) {
                        this.checkUserAbort();
                        this.atlasProgress.incMapCreationProgress();
                        try {
                            BufferedImage tile = this.mapDlTileProvider.getTileImage(x, y);
                            if (tile != null) {
                                graphics.drawImage(tile, lineX, 0, Color.WHITE, null);
                            }
                        }
                        catch (IOException e) {
                            this.log.error("", e);
                        }
                        lineX += this.tileSize;
                    }
                }
                finally {
                    graphics.dispose();
                }
                pngWriter.writeTileLine(lineImage);
            }
            pngWriter.finish();
            Utilities.closeStream(fileOs);
        }
        catch (IOException e) {
            this.log.error("", e);
        }
        finally {
            Utilities.closeStream(fileOs);
        }
    }
}

