/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Locale;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarArchive;
import mobac.utilities.tar.TarIndex;
import mobac.utilities.tar.TarTmiArchive;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public abstract class TrekBuddy
extends AtlasCreator {
    protected File mapFolder = null;
    protected MapTileWriter mapTileWriter;

    @Override
    public void startAtlasCreation(AtlasInterface atlas) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas);
    }

    @Override
    public void finishAtlasCreation() {
        switch (this.atlas.getOutputFormat()) {
            case TaredAtlas: {
                this.createAtlasTarArchive("cr");
                break;
            }
            case UntaredAtlas: {
                this.createAtlasTbaFile("cr");
            }
        }
    }

    @Override
    public void initializeMap(MapInterface map, TarIndex tarTileIndex) {
        super.initializeMap(map, tarTileIndex);
        LayerInterface layer = map.getLayer();
        this.mapFolder = new File(new File(this.atlasDir, layer.getName()), map.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapFile() throws IOException {
        File mapFile = new File(this.mapFolder, this.map.getName() + ".map");
        FileOutputStream mapFileStream = null;
        try {
            mapFileStream = new FileOutputStream(mapFile);
            this.writeMapFile(mapFileStream);
        }
        catch (Throwable throwable) {
            Utilities.closeStream(mapFileStream);
            throw throwable;
        }
        Utilities.closeStream(mapFileStream);
    }

    protected void writeMapFile(OutputStream stream) throws IOException {
        this.writeMapFile("t_." + this.mapSource.getTileType(), stream);
    }

    protected void writeMapFile(String imageFileName, OutputStream stream) throws IOException {
        this.log.trace("Writing map file");
        OutputStreamWriter mapWriter = new OutputStreamWriter(stream, "ISO-8859-1");
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        mapWriter.write(this.prepareMapString(imageFileName, longitudeMin, longitudeMax, latitudeMin, latitudeMax, width, height));
        mapWriter.flush();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int tilex = 0;
        int tiley = 0;
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        byte[] emptyTileData = Utilities.createEmptyTileData(this.mapSource);
        String tileType = this.mapSource.getTileType();
        for (int x = this.xMin; x <= this.xMax; ++x) {
            tiley = 0;
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData != null) {
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, sourceTileData);
                    } else {
                        this.log.trace(String.format("Tile x=%d y=%d not found in tile archive - creating default", tilex, tiley));
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, emptyTileData);
                    }
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), e);
                }
                ++tiley;
            }
            ++tilex;
        }
    }

    protected String prepareMapString(String fileName, double longitudeMin, double longitudeMax, double latitudeMin, double latitudeMax, int width, int height) {
        StringBuffer sbMap = new StringBuffer();
        sbMap.append("OziExplorer Map Data File Version 2.2\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append("1 ,Map Code,\r\n");
        sbMap.append("WGS 84,WGS 84,   0.0000,   0.0000,WGS 84\r\n");
        sbMap.append("Reserved 1\r\n");
        sbMap.append("Reserved 2\r\n");
        sbMap.append("Magnetic Variation,,,E\r\n");
        sbMap.append("Map Projection,Mercator,PolyCal,No,AutoCalOnly,No,BSBUseWPX,No\r\n");
        String latMax = TrekBuddy.getDegMinFormat(latitudeMax, 1);
        String latMin = TrekBuddy.getDegMinFormat(latitudeMin, 1);
        String lonMax = TrekBuddy.getDegMinFormat(longitudeMax, 2);
        String lonMin = TrekBuddy.getDegMinFormat(longitudeMin, 2);
        String pointLine = "Point%02d,xy, %4s, %4s,in, deg, %1s, %1s, grid, , , ,N\r\n";
        sbMap.append(String.format(pointLine, 1, 0, 0, latMax, lonMin));
        sbMap.append(String.format(pointLine, 2, width - 1, 0, latMax, lonMax));
        sbMap.append(String.format(pointLine, 3, width - 1, height - 1, latMin, lonMax));
        sbMap.append(String.format(pointLine, 4, 0, height - 1, latMin, lonMin));
        for (int i = 5; i <= 30; ++i) {
            String s = String.format(pointLine, i, "", "", "", "");
            sbMap.append(s);
        }
        sbMap.append("Projection Setup,,,,,,,,,,\r\n");
        sbMap.append("Map Feature = MF ; Map Comment = MC     These follow if they exist\r\n");
        sbMap.append("Track File = TF      These follow if they exist\r\n");
        sbMap.append("Moving Map Parameters = MM?    These follow if they exist\r\n");
        sbMap.append("MM0,Yes\r\n");
        sbMap.append("MMPNUM,4\r\n");
        String mmpxLine = "MMPXY, %d, %5d, %5d\r\n";
        sbMap.append(String.format(mmpxLine, 1, 0, 0));
        sbMap.append(String.format(mmpxLine, 2, width - 1, 0));
        sbMap.append(String.format(mmpxLine, 3, width - 1, height - 1));
        sbMap.append(String.format(mmpxLine, 4, 0, height - 1));
        String mpllLine = "MMPLL, %d, %2.6f, %2.6f\r\n";
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 1, longitudeMin, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 2, longitudeMax, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 3, longitudeMax, latitudeMin));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 4, longitudeMin, latitudeMin));
        sbMap.append("IWH,Map Image Width/Height, " + width + ", " + height + "\r\n");
        return sbMap.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAtlasTarArchive(String name) {
        this.log.trace("Creating cr.tar for atlas in dir \"" + this.atlasDir.getPath() + "\"");
        File[] atlasLayerDirs = Utilities.listSubDirectories(this.atlasDir);
        LinkedList<File> atlasMapDirs = new LinkedList<File>();
        for (File dir : atlasLayerDirs) {
            Utilities.addSubDirectories(atlasMapDirs, dir, 0);
        }
        TarArchive ta = null;
        File crFile = new File(this.atlasDir, name + ".tar");
        try {
            ta = new TarArchive(crFile, this.atlasDir);
            ta.writeFileFromData(name + ".tba", "Atlas 1.0\r\n".getBytes());
            for (File mapDir : atlasMapDirs) {
                ta.writeFile(mapDir);
                File mapFile = new File(mapDir, mapDir.getName() + ".map");
                ta.writeFile(mapFile);
                try {
                    mapFile.delete();
                }
                catch (Exception e) {}
            }
            ta.writeEndofArchive();
        }
        catch (IOException e) {
            this.log.error("Failed writing tar file \"" + crFile.getPath() + "\"", e);
        }
        finally {
            if (ta != null) {
                ta.close();
            }
        }
    }

    public void createAtlasTbaFile(String name) {
        File crtba = new File(this.atlasDir.getAbsolutePath(), name + ".tba");
        try {
            FileWriter fw = new FileWriter(crtba);
            fw.write("Atlas 1.0\r\n");
            fw.close();
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    private static String getDegMinFormat(double coord, int COORD_KIND) {
        boolean neg = coord < 0.0;
        coord = Math.abs(coord);
        int deg = (int)coord;
        double min = (coord - (double)deg) * 60.0;
        String degMinFormat = "%d, %3.6f, %c";
        char dirC = COORD_KIND == 1 ? (neg ? (char)'S' : 'N') : (neg ? (char)'W' : 'E');
        return String.format(Locale.ENGLISH, degMinFormat, deg, min, Character.valueOf(dirC));
    }

    public class FileTileWriter
    implements MapTileWriter {
        File setFolder;
        Writer setFileWriter;
        int tileHeight = 256;
        int tileWidth = 256;

        public FileTileWriter() throws IOException {
            this.setFolder = new File(TrekBuddy.this.mapFolder, "set");
            Utilities.mkDir(this.setFolder);
            TrekBuddy.this.log.debug("Writing tiles to set folder: " + this.setFolder);
            File setFile = new File(TrekBuddy.this.mapFolder, TrekBuddy.this.map.getName() + ".set");
            if (TrekBuddy.this.parameters != null) {
                this.tileHeight = TrekBuddy.this.parameters.getHeight();
                this.tileWidth = TrekBuddy.this.parameters.getWidth();
            }
            try {
                this.setFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(setFile), "ISO-8859-1"));
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("t_%d_%d.%s", tilex * this.tileWidth, tiley * this.tileHeight, imageFormat);
            File f = new File(this.setFolder, tileFileName);
            FileOutputStream out = new FileOutputStream(f);
            this.setFileWriter.write(tileFileName + "\r\n");
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
        }

        @Override
        public void finalizeMap() {
            try {
                this.setFileWriter.flush();
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
            Utilities.closeWriter(this.setFileWriter);
        }
    }

    public class TarTileWriter
    implements MapTileWriter {
        TarArchive ta = null;
        int tileHeight = 256;
        int tileWidth = 256;

        public TarTileWriter() {
            if (TrekBuddy.this.parameters != null) {
                this.tileHeight = TrekBuddy.this.parameters.getHeight();
                this.tileWidth = TrekBuddy.this.parameters.getWidth();
            }
            File mapTarFile = new File(TrekBuddy.this.mapFolder, TrekBuddy.this.map.getName() + ".tar");
            TrekBuddy.this.log.debug("Writing tiles to tared map: " + mapTarFile);
            try {
                this.ta = new TarTmiArchive(mapTarFile, null);
                ByteArrayOutputStream buf = new ByteArrayOutputStream(8192);
                TrekBuddy.this.writeMapFile(buf);
                this.ta.writeFileFromData(TrekBuddy.this.map.getName() + ".map", buf.toByteArray());
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
        }

        @Override
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("t_%d_%d.%s", tilex * this.tileWidth, tiley * this.tileHeight, imageFormat);
            this.ta.writeFileFromData("set/" + tileFileName, tileData);
        }

        @Override
        public void finalizeMap() {
            try {
                this.ta.writeEndofArchive();
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
            this.ta.close();
        }
    }
}

