/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.atlascreators.TrekBuddy;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.model.AtlasOutputFormat;
import mobac.utilities.Utilities;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class TrekBuddyCustom
extends TrekBuddy {
    @Override
    public boolean testMapSource(MapSource mapSource) {
        return mapSource.getMapSpace() instanceof MercatorPower2MapSpace;
    }

    @Override
    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.mapFolder);
            this.writeMapFile();
            this.mapTileWriter = this.atlasOutputFormat == AtlasOutputFormat.TaredAtlas ? new TrekBuddy.TarTileWriter() : new TrekBuddy.FileTileWriter();
            if (this.parameters != null) {
                this.createTiles();
            } else {
                super.createTiles();
            }
            this.mapTileWriter.finalizeMap();
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTiles() throws InterruptedException, MapCreationException {
        this.log.debug("Starting map creation using custom parameters: " + this.parameters);
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, this.mapTileWriter, true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        finally {
            ctp.cleanup();
        }
    }
}

