/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.io.IOException;
import java.io.OutputStream;

public class ChecksumOutputStream
extends OutputStream {
    private OutputStream nextStream;
    int checksum;
    boolean evenByte;

    public ChecksumOutputStream(OutputStream next_stream) {
        this.nextStream = next_stream;
        this.checksum = 0;
        this.evenByte = true;
    }

    public void writeChecksum() throws IOException {
        this.nextStream.write(this.checksum >> 8 & 0xFF);
        this.nextStream.write(this.checksum & 0xFF);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        int o = off;
        for (int i = 0; i < len; ++i) {
            int value = this.evenByte ? (buf[o++] & 0xFF) << 8 : buf[o++] & 0xFF;
            this.checksum ^= value;
            this.evenByte = !this.evenByte;
        }
        this.nextStream.write(buf, off, len);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int val) throws IOException {
        int value = this.evenByte ? (val & 0xFF) << 8 : val & 0xFF;
        this.checksum ^= value;
        this.evenByte = !this.evenByte;
        this.nextStream.write(val);
    }

    @Override
    public void close() throws IOException {
        this.nextStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.nextStream.flush();
    }
}

