/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RmpTools {
    public static void writeValue(OutputStream stream, int value, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            stream.write(value & 0xFF);
            value >>= 8;
        }
    }

    public static void writeValue(OutputStream stream, long value, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            stream.write((int)(value & 0xFFL));
            value >>= 8;
        }
    }

    public static void writeFixedString(OutputStream stream, String str, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char value = i < str.length() ? str.charAt(i) : (char)'\u0000';
            stream.write(value);
        }
    }

    public static void writeDouble(OutputStream os, double value) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bo);
        dos.writeDouble(value);
        dos.close();
        byte[] b = bo.toByteArray();
        for (int i = 0; i < 4; ++i) {
            byte help = b[i];
            b[i] = b[7 - i];
            b[7 - i] = help;
        }
        os.write(b);
    }

    public static String buildImageName(String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        if (name.length() > 8) {
            name = name.substring(0, 8);
        }
        return name.toLowerCase().trim();
    }

    public static String buildTileName(String basename, int index) {
        String indexstr = String.valueOf(index);
        if (indexstr.length() + basename.length() > 8) {
            basename = basename.substring(0, 8 - indexstr.length());
        }
        return basename.trim() + indexstr;
    }
}

