/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.Tiledata;

public class TileContainer {
    private final TileContainer previous;
    private final ArrayList<Tiledata> tiles;
    private final ArrayList<TileContainer> followUps;

    public TileContainer() {
        this(null);
    }

    public TileContainer(TileContainer previous) {
        this.previous = previous;
        this.tiles = new ArrayList(100);
        this.followUps = new ArrayList();
    }

    public void addTile(Tiledata tile, TileContainer next) {
        this.tiles.add(tile);
        if (this.previous != null) {
            this.followUps.add(next);
        }
    }

    public int getTileCount() {
        int count = this.tiles.size();
        if (this.previous != null) {
            count += this.previous.getTileCount();
        }
        for (TileContainer next : this.followUps) {
            count += next.getTileCount();
        }
        return count;
    }

    public int getContainerCount() {
        return 1 + this.followUps.size();
    }

    public void writeTree(OutputStream os) throws IOException {
        if (this.previous != null) {
            this.previous.writeTree(os);
            this.writeContainer(os);
            for (TileContainer tc : this.followUps) {
                tc.writeTree(os);
            }
        } else {
            this.writeContainer(os);
        }
    }

    public void writeContainer(OutputStream os) throws IOException {
        int i;
        RmpTools.writeValue(os, this.getTileCount(), 4);
        RmpTools.writeValue(os, this.tiles.size(), 2);
        RmpTools.writeValue(os, this.previous == null ? 1 : 0, 2);
        for (i = 0; i < 99; ++i) {
            int x = 0;
            int y = 0;
            int offset = 0;
            if (i < this.tiles.size()) {
                x = this.tiles.get((int)i).posx;
                y = this.tiles.get((int)i).posy;
                offset = this.tiles.get((int)i).totalOffset;
            }
            RmpTools.writeValue(os, x, 4);
            RmpTools.writeValue(os, y, 4);
            RmpTools.writeValue(os, 0, 4);
            RmpTools.writeValue(os, offset, 4);
        }
        if (this.previous == null) {
            RmpTools.writeValue(os, 0, 4);
        } else {
            RmpTools.writeValue(os, 3932, 4);
        }
        for (i = 0; i < 99; ++i) {
            if (i < this.followUps.size()) {
                RmpTools.writeValue(os, 3932 + (i + 2) * 1992, 4);
                continue;
            }
            RmpTools.writeValue(os, 0, 4);
        }
    }
}

