/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import mobac.program.atlascreators.tileprovider.FilterTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import org.apache.log4j.Logger;

public class CacheTileProvider
extends FilterTileProvider {
    private Logger log = Logger.getLogger(CacheTileProvider.class);
    private static int PRELOADER_THREAD_NUM = 1;
    private Hashtable<CacheKey, SRCachedTile> cache;
    private PreLoadThread preLoader = new PreLoadThread();

    public CacheTileProvider(TileProvider tileProvider) {
        super(tileProvider);
        this.cache = new Hashtable(500);
        this.preLoader.start();
    }

    @Override
    public BufferedImage getTileImage(int x, int y, int layer) throws IOException {
        CachedTile tile;
        SRCachedTile cachedTile = this.cache.get(new CacheKey(x, y, layer));
        BufferedImage image = null;
        if (cachedTile != null && (tile = (CachedTile)cachedTile.get()) != null) {
            if (tile.loaded) {
                this.log.trace(String.format("Cache hit: x=%d y=%d l=%d", x, y, layer));
            }
            image = tile.getImage();
            if (!tile.nextLoadJobCreated) {
                this.preloadTile(new CachedTile(new CacheKey(x + 1, y, layer)));
                tile.nextLoadJobCreated = true;
            }
        }
        if (image == null) {
            this.log.trace(String.format("Cache miss: x=%d y=%d l=%d", x, y, layer));
            this.preloadTile(new CachedTile(new CacheKey(x + 1, y, layer)));
            image = this.internalGetTileImage(x, y, layer);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage internalGetTileImage(int x, int y, int layer) throws IOException {
        TileProvider tileProvider = this.tileProvider;
        synchronized (tileProvider) {
            return super.getTileImage(x, y, layer);
        }
    }

    @Override
    public byte[] getTileData(int layer, int x, int y) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public byte[] getTileData(int x, int y) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    private void preloadTile(CachedTile tile) {
        if (this.cache.get(tile.key) != null) {
            return;
        }
        this.preLoader.queue.add(tile);
        this.cache.put(tile.key, new SRCachedTile(tile));
    }

    public void cleanup() {
        try {
            this.cache.clear();
            if (this.preLoader != null) {
                this.preLoader.interrupt();
                this.preLoader = null;
            }
        }
        catch (Throwable t) {
            this.log.error("", t);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private class CachedTile {
        CacheKey key;
        private BufferedImage image;
        boolean loaded = false;
        boolean nextLoadJobCreated = false;

        public CachedTile(CacheKey key) {
            this.key = key;
            this.image = null;
        }

        public synchronized void loadImage() {
            try {
                this.image = CacheTileProvider.this.internalGetTileImage(this.key.x, this.key.y, this.key.layer);
            }
            catch (Exception e) {
                CacheTileProvider.this.log.error("", e);
            }
            this.loaded = true;
        }

        public synchronized BufferedImage getImage() {
            if (!this.loaded) {
                this.loadImage();
            }
            return this.image;
        }

        public String toString() {
            return "CachedTile [key=" + this.key + ", loaded=" + this.loaded + ", nextLoadJobCreated=" + this.nextLoadJobCreated + "]";
        }
    }

    private static class CacheKey {
        int x;
        int y;
        int layer;

        public CacheKey(int x, int y, int layer) {
            this.x = x;
            this.y = y;
            this.layer = layer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.layer;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.layer != other.layer) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        public String toString() {
            return "CacheKey [x=" + this.x + ", y=" + this.y + ", layer=" + this.layer + "]";
        }
    }

    private class PreLoadThread
    extends Thread {
        private LinkedBlockingQueue<CachedTile> queue;

        public PreLoadThread() {
            super("ImagePreLoadThread" + PRELOADER_THREAD_NUM++);
            this.queue = null;
            CacheTileProvider.this.log.debug("Image pre-loader thread started");
            this.queue = new LinkedBlockingQueue();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    CachedTile tile;
                    if ((tile = this.queue.take()) == null || tile.loaded) {
                        continue;
                    }
                    tile.loadImage();
                }
            }
            catch (InterruptedException e) {
                CacheTileProvider.this.log.debug("Image pre-loader thread terminated");
                return;
            }
        }
    }

    private static class SRCachedTile
    extends SoftReference<CachedTile> {
        public SRCachedTile(CachedTile referent) {
            super(referent);
        }
    }
}

