/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.utilities.tar.TarIndex;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class DownloadedTileProvider
implements TileProvider {
    protected final TarIndex tarIndex;
    protected final String mapTileType;

    public DownloadedTileProvider(TarIndex tarIndex, MapSource mapSource) {
        this.tarIndex = tarIndex;
        this.mapTileType = mapSource.getTileType();
    }

    @Override
    public byte[] getTileData(int x, int y) throws IOException {
        return this.getTileData(x, y, 0);
    }

    @Override
    public byte[] getTileData(int x, int y, int layer) throws IOException {
        return this.tarIndex.getEntryContent(String.format("l%dx%dy%d", layer, x, y));
    }

    @Override
    public BufferedImage getTileImage(int x, int y) throws IOException {
        return this.getTileImage(x, y, 0);
    }

    @Override
    public BufferedImage getTileImage(int x, int y, int layer) throws IOException {
        byte[] unconvertedTileData = this.getTileData(x, y, layer);
        if (unconvertedTileData == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(unconvertedTileData));
    }
}

