/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import mobac.program.atlascreators.tileprovider.FilterTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.model.TileImageFormat;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class MultiLayerTileProvider
extends FilterTileProvider {
    private final MapSource mapSource;
    private TileImageDataWriter writer;
    private int layerCount;

    public MultiLayerTileProvider(MapSource mapSource, TileProvider tileProvider, int layerCount) {
        super(tileProvider);
        this.mapSource = mapSource;
        this.layerCount = layerCount;
        TileImageFormat tileImageFormat = TileImageFormat.PNG;
        this.writer = tileImageFormat.getDataWriter();
        this.writer.initialize();
        ImageIO.setUseCache(false);
    }

    @Override
    public byte[] getTileData(int layer, int x, int y) throws IOException {
        return this.getTileData(x, y);
    }

    @Override
    public byte[] getTileData(int x, int y) throws IOException {
        BufferedImage combinedImage = this.getTileImage(x, y);
        if (combinedImage == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(32000);
        this.writer.processImage(combinedImage, buffer);
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getTileImage(int x, int y, int layer) throws IOException {
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        BufferedImage combinedImage = new BufferedImage(tileSize, tileSize, 5);
        Graphics g = combinedImage.getGraphics();
        boolean used = false;
        try {
            for (int l = 0; l < this.layerCount; ++l) {
                BufferedImage image = this.tileProvider.getTileImage(x, y, l);
                if (image == null) continue;
                g.drawImage(image, 0, 0, null);
                used = true;
            }
        }
        finally {
            g.dispose();
        }
        if (used) {
            return combinedImage;
        }
        return null;
    }
}

