/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import mobac.exceptions.DownloadFailedException;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.program.JobDispatcher;
import mobac.program.download.TileDownLoader;
import mobac.program.interfaces.DownloadJobListener;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class DownloadJob
implements JobDispatcher.Job {
    static Logger log = Logger.getLogger(DownloadJob.class);
    int errorCounter = 0;
    final MapSource mapSource;
    final int layer;
    final int xValue;
    final int yValue;
    final int zoomValue;
    final TarIndexedArchive tileArchive;
    final DownloadJobListener listener;

    public DownloadJob(MapSource mapSource, int layer, int xValue, int yValue, int zoomValue, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this.mapSource = mapSource;
        this.layer = layer;
        this.xValue = xValue;
        this.yValue = yValue;
        this.zoomValue = zoomValue;
        this.tileArchive = tileArchive;
        this.listener = listener;
    }

    @Override
    public void run(JobDispatcher dispatcher) throws Exception {
        try {
            this.listener.jobStarted();
            int bytes = TileDownLoader.getImage(this.layer, this.xValue, this.yValue, this.zoomValue, this.mapSource, this.tileArchive);
            this.listener.jobFinishedSuccessfully(bytes);
        }
        catch (UnrecoverableDownloadException e) {
            this.listener.jobFinishedWithError(false);
            log.error("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed with an unrecoverable error: " + e.getCause());
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            this.processError(dispatcher, e);
        }
        catch (ConnectException e) {
            this.processError(dispatcher, e);
        }
        catch (DownloadFailedException e) {
            this.processError(dispatcher, e);
        }
        catch (Exception e) {
            this.processError(dispatcher, e);
            throw e;
        }
    }

    private void processError(JobDispatcher dispatcher, Exception e) {
        ++this.errorCounter;
        if (this.errorCounter <= 1) {
            this.listener.jobFinishedWithError(true);
            log.warn("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed: \"" + e.getMessage() + "\" (tries: " + this.errorCounter + ") - rescheduling download job");
            dispatcher.addErrorJob(this);
        } else {
            this.listener.jobFinishedWithError(false);
            log.error("Download of tile z" + this.zoomValue + "_x" + this.xValue + "_y" + this.yValue + " failed again: \"" + e.getMessage() + "\". Retry limit reached, " + "job will not be rescheduled (no further try)");
        }
    }

    public String toString() {
        return "DownloadJob l=" + this.layer + " x=" + this.xValue + " y=" + this.yValue + " z=" + this.zoomValue;
    }
}

