/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download;

import java.util.Enumeration;
import mobac.program.AtlasThread;
import mobac.program.JobDispatcher;
import mobac.program.interfaces.DownloadableElement;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;

public class DownloadJobProducerThread
extends Thread {
    private Logger log = Logger.getLogger(DownloadJobProducerThread.class);
    final JobDispatcher downloadJobDispatcher;
    final Enumeration<JobDispatcher.Job> jobEnumerator;

    public DownloadJobProducerThread(AtlasThread atlasThread, JobDispatcher jobDispatcher, TarIndexedArchive tarIndexedArchive, DownloadableElement downloadableElement) {
        this.downloadJobDispatcher = jobDispatcher;
        this.jobEnumerator = downloadableElement.getDownloadJobs(tarIndexedArchive, atlasThread);
        this.start();
    }

    @Override
    public void run() {
        try {
            while (this.jobEnumerator.hasMoreElements()) {
                JobDispatcher.Job job = this.jobEnumerator.nextElement();
                this.downloadJobDispatcher.addJob(job);
                this.log.trace("Job added: " + job);
            }
            this.log.debug("All download jobs has been generated");
        }
        catch (InterruptedException e) {
            this.downloadJobDispatcher.cancelOutstandingJobs();
            this.log.error("Download job generation interrupted");
        }
    }

    public void cancel() {
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

