/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download.jobenumerators;

import java.awt.Polygon;
import mobac.program.JobDispatcher;
import mobac.program.download.DownloadJob;
import mobac.program.download.jobenumerators.DJERectangle;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.model.MapPolygon;
import mobac.utilities.tar.TarIndexedArchive;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class DJEPolygon
extends DJERectangle {
    protected final int tileSize;
    protected Polygon polygon;

    public DJEPolygon(MapPolygon map, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this(map, map.getMapSource(), 0, tileArchive, listener);
    }

    protected DJEPolygon(MapPolygon map, MapSource mapSource, int layer, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        super(map, mapSource, layer, tileArchive, listener);
        this.polygon = map.getPolygon();
        this.tileSize = mapSource.getMapSpace().getTileSize();
        --this.x;
        this.nextElement();
    }

    @Override
    public JobDispatcher.Job nextElement() {
        int tileCoordinateY;
        int tileCoordinateX;
        DownloadJob job = this.nextJob;
        boolean intersects = false;
        do {
            ++this.x;
            if (this.x <= this.xMax) continue;
            ++this.y;
            this.x = this.xMin;
            if (this.y <= this.yMax) continue;
            this.nextJob = null;
            return job;
        } while (!(intersects = this.polygon.intersects(tileCoordinateX = this.x * this.tileSize, tileCoordinateY = this.y * this.tileSize, this.tileSize, this.tileSize)));
        this.nextJob = new DownloadJob(this.mapSource, this.layer, this.x, this.y, this.zoom, this.tileArchive, this.listener);
        return job;
    }
}

