/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.download.jobenumerators;

import java.awt.Point;
import mobac.program.JobDispatcher;
import mobac.program.download.DownloadJob;
import mobac.program.interfaces.DownloadJobEnumerator;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.model.Map;
import mobac.utilities.tar.TarIndexedArchive;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class DJERectangle
implements DownloadJobEnumerator {
    protected final DownloadJobListener listener;
    protected final int xMin;
    protected final int xMax;
    protected final int yMax;
    protected final int zoom;
    protected final int layer;
    protected final MapSource mapSource;
    protected final TarIndexedArchive tileArchive;
    protected int x;
    protected int y;
    protected DownloadJob nextJob;

    public DJERectangle(Map map, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this(map, map.getMapSource(), 0, tileArchive, listener);
    }

    protected DJERectangle(Map map, MapSource mapSource, int layer, TarIndexedArchive tileArchive, DownloadJobListener listener) {
        this.listener = listener;
        Point minCoord = map.getMinTileCoordinate();
        Point maxCoord = map.getMaxTileCoordinate();
        int tileSize = map.getMapSource().getMapSpace().getTileSize();
        this.xMin = minCoord.x / tileSize;
        this.xMax = maxCoord.x / tileSize;
        int yMin = minCoord.y / tileSize;
        this.yMax = maxCoord.y / tileSize;
        this.zoom = map.getZoom();
        this.tileArchive = tileArchive;
        this.mapSource = mapSource;
        this.layer = layer;
        this.y = yMin;
        this.x = this.xMin;
        this.nextJob = new DownloadJob(mapSource, layer, this.x, this.y, this.zoom, tileArchive, listener);
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextJob != null;
    }

    @Override
    public JobDispatcher.Job nextElement() {
        DownloadJob job = this.nextJob;
        ++this.x;
        if (this.x > this.xMax) {
            ++this.y;
            this.x = this.xMin;
            if (this.y > this.yMax) {
                this.nextJob = null;
                return job;
            }
        }
        this.nextJob = new DownloadJob(this.mapSource, this.layer, this.x, this.y, this.zoom, this.tileArchive, this.listener);
        return job;
    }
}

