/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Point;
import java.awt.geom.Point2D;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.utilities.Utilities;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

@XmlRootElement
public class EastNorthCoordinate {
    @XmlAttribute
    public double lat;
    @XmlAttribute
    public double lon;

    public EastNorthCoordinate() {
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public EastNorthCoordinate(MapSpace mapSpace, int zoom, int pixelCoordinateX, int pixelCoordinateY) {
        this.lat = mapSpace.cYToLat(pixelCoordinateY, zoom);
        this.lon = mapSpace.cXToLon(pixelCoordinateX, zoom);
    }

    public EastNorthCoordinate(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public EastNorthCoordinate(Point2D.Double c) {
        this.lat = c.y;
        this.lon = c.x;
    }

    public Point toTileCoordinate(MapSpace mapSpace, int zoom) {
        int x = mapSpace.cLonToX(this.lon, zoom);
        int y = mapSpace.cLatToY(this.lat, zoom);
        return new Point(x, y);
    }

    public String toString() {
        return Utilities.prettyPrintLatLon(this.lat, true) + " " + Utilities.prettyPrintLatLon(this.lon, false);
    }
}

