/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Dimension;
import java.awt.Point;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import mobac.exceptions.InvalidNameException;
import mobac.mapsources.MultiLayerMapSource;
import mobac.program.JobDispatcher;
import mobac.program.download.jobenumerators.DJEMultiLayer;
import mobac.program.download.jobenumerators.DJERectangle;
import mobac.program.interfaces.CapabilityDeletable;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.DownloadableElement;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.ToolTipProvider;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Layer;
import mobac.program.model.TileImageParameters;
import mobac.utilities.tar.TarIndexedArchive;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class Map
implements TreeNode,
CapabilityDeletable,
DownloadableElement,
MapInterface,
ToolTipProvider {
    protected String name;
    protected Layer layer;
    protected TileImageParameters parameters = null;
    @XmlAttribute
    protected Point maxTileCoordinate = null;
    @XmlAttribute
    protected Point minTileCoordinate = null;
    @XmlAttribute
    protected MapSource mapSource = null;
    protected Dimension tileDimension = null;
    @XmlAttribute
    protected int zoom;
    private static Logger log = Logger.getLogger(Map.class);

    protected Map() {
    }

    protected Map(Layer layer, String name, MapSource mapSource, int zoom, Point minTileCoordinate, Point maxTileCoordinate, TileImageParameters parameters) {
        this.layer = layer;
        this.maxTileCoordinate = maxTileCoordinate;
        this.minTileCoordinate = minTileCoordinate;
        this.name = name;
        this.mapSource = mapSource;
        this.zoom = zoom;
        this.parameters = parameters;
        this.calculateRuntimeValues();
    }

    protected void calculateRuntimeValues() {
        if (this.parameters == null) {
            int tileSize = this.mapSource.getMapSpace().getTileSize();
            this.tileDimension = new Dimension(tileSize, tileSize);
        } else {
            this.tileDimension = this.parameters.getDimension();
        }
    }

    @Override
    public LayerInterface getLayer() {
        return this.layer;
    }

    @Override
    @XmlTransient
    public void setLayer(LayerInterface layer) {
        this.layer = (Layer)layer;
    }

    @Override
    public MapSource getMapSource() {
        return this.mapSource;
    }

    @Override
    public Point getMaxTileCoordinate() {
        return this.maxTileCoordinate;
    }

    @Override
    public Point getMinTileCoordinate() {
        return this.minTileCoordinate;
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public TileImageParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(TileImageParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getToolTip() {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        EastNorthCoordinate tl = new EastNorthCoordinate(mapSpace, this.zoom, this.minTileCoordinate.x, this.minTileCoordinate.y);
        EastNorthCoordinate br = new EastNorthCoordinate(mapSpace, this.zoom, this.maxTileCoordinate.x, this.maxTileCoordinate.y);
        StringWriter sw = new StringWriter(1024);
        sw.write("<html>");
        sw.write("<b>Map</b><br>");
        sw.write("Map source: " + this.mapSource.getName() + "<br>");
        sw.write("Zoom level: " + this.zoom + "<br>");
        sw.write("Area start: " + tl + " (" + this.minTileCoordinate.x + " / " + this.minTileCoordinate.y + ")<br>");
        sw.write("Area end: " + br + " (" + this.maxTileCoordinate.x + " / " + this.maxTileCoordinate.y + ")<br>");
        sw.write("Map size: " + (this.maxTileCoordinate.x - this.minTileCoordinate.x + 1) + "x" + (this.maxTileCoordinate.y - this.minTileCoordinate.y + 1) + " pixel<br>");
        if (this.parameters != null) {
            sw.write("Tile size: " + this.parameters.getWidth() + "x" + this.parameters.getHeight() + "<br>");
            sw.write("Tile format: " + (Object)((Object)this.parameters.getFormat()) + "<br>");
        } else {
            sw.write("Tile size: 256x256 (no processing)<br>");
        }
        sw.write("Maximum tiles to download: " + this.calculateTilesToDownload() + "<br>");
        sw.write("</html>");
        return sw.toString();
    }

    @Override
    public Dimension getTileSize() {
        return this.tileDimension;
    }

    @Override
    public void delete() {
        this.layer.deleteMap(this);
    }

    @Override
    public void setName(String newName) throws InvalidNameException {
        if (this.layer != null) {
            for (MapInterface map : this.layer) {
                if (map == this || !newName.equals(map.getName())) continue;
                throw new InvalidNameException("There is already a map named \"" + newName + "\" in this layer.\nMap names have to unique within an layer.");
            }
        }
        this.name = newName;
    }

    public Enumeration<?> children() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode node) {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.layer;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int calculateTilesToDownload() {
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        int xMin = this.minTileCoordinate.x / tileSize;
        int xMax = this.maxTileCoordinate.x / tileSize;
        int yMin = this.minTileCoordinate.y / tileSize;
        int yMax = this.maxTileCoordinate.y / tileSize;
        int width = xMax - xMin + 1;
        int height = yMax - yMin + 1;
        int tileCount = width * height;
        if (this.mapSource instanceof MultiLayerMapSource) {
            tileCount *= 2;
        }
        return tileCount;
    }

    @Override
    public boolean checkData() {
        boolean result = false;
        boolean[] checks = new boolean[]{this.name == null, this.layer == null, this.maxTileCoordinate == null, this.minTileCoordinate == null, this.mapSource == null, this.zoom < 0};
        for (int i = 0; i < checks.length; ++i) {
            if (!checks[i]) continue;
            log.error("Problem detectected with map \"" + this.name + "\" check: " + i);
            result = true;
        }
        try {
            int tmp;
            if (this.minTileCoordinate.x > this.maxTileCoordinate.x) {
                tmp = this.maxTileCoordinate.x;
                this.maxTileCoordinate.x = this.minTileCoordinate.x;
                this.minTileCoordinate.x = tmp;
            }
            if (this.minTileCoordinate.y > this.maxTileCoordinate.y) {
                tmp = this.maxTileCoordinate.y;
                this.maxTileCoordinate.y = this.minTileCoordinate.y;
                this.minTileCoordinate.y = tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public MapInterface deepClone(LayerInterface newLayer) {
        try {
            Map map = (Map)this.getClass().newInstance();
            map.layer = (Layer)newLayer;
            map.mapSource = this.mapSource;
            map.maxTileCoordinate = (Point)this.maxTileCoordinate.clone();
            map.minTileCoordinate = (Point)this.minTileCoordinate.clone();
            map.name = this.name;
            map.parameters = this.parameters != null ? (TileImageParameters)this.parameters.clone() : null;
            map.tileDimension = (Dimension)this.tileDimension.clone();
            map.zoom = this.zoom;
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.layer = (Layer)parent;
        this.calculateRuntimeValues();
    }

    @Override
    public Enumeration<JobDispatcher.Job> getDownloadJobs(TarIndexedArchive tileArchive, DownloadJobListener listener) {
        if (this.mapSource instanceof MultiLayerMapSource) {
            return new DJEMultiLayer(this, tileArchive, listener);
        }
        return new DJERectangle(this, tileArchive, listener);
    }
}

