/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Point;
import java.awt.Polygon;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.mapsources.MultiLayerMapSource;
import mobac.program.JobDispatcher;
import mobac.program.download.jobenumerators.DJEMultiLayer;
import mobac.program.download.jobenumerators.DJEPolygon;
import mobac.program.interfaces.DownloadJobListener;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Layer;
import mobac.program.model.Map;
import mobac.program.model.TileImageParameters;
import mobac.utilities.tar.TarIndexedArchive;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

@XmlRootElement
public class MapPolygon
extends Map {
    @XmlElement
    protected Polygon polygon = new Polygon();

    protected MapPolygon() {
    }

    public MapPolygon(Layer layer, String name, MapSource mapSource, int zoom, Point minTileCoordinate, Point maxTileCoordinate, TileImageParameters parameters) {
        super(layer, name, mapSource, zoom, minTileCoordinate, maxTileCoordinate, parameters);
        int xMid = (maxTileCoordinate.x + minTileCoordinate.x) / 2;
        int yMid = (maxTileCoordinate.y + minTileCoordinate.y) / 2;
        this.polygon.addPoint(xMid, minTileCoordinate.y);
        this.polygon.addPoint(maxTileCoordinate.x, yMid);
        this.polygon.addPoint(xMid, maxTileCoordinate.y);
        this.polygon.addPoint(minTileCoordinate.x, yMid);
    }

    @Override
    public int calculateTilesToDownload() {
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        double tileSizeD = tileSize;
        int xMin = this.minTileCoordinate.x;
        int xMax = this.maxTileCoordinate.x;
        int yMin = this.minTileCoordinate.y;
        int yMax = this.maxTileCoordinate.y;
        int count = 0;
        for (int x = xMin; x <= xMax; x += tileSize) {
            for (int y = yMin; y <= yMax; y += tileSize) {
                if (!this.polygon.intersects(x, y, tileSizeD, tileSizeD)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public String getToolTip() {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        EastNorthCoordinate tl = new EastNorthCoordinate(mapSpace, this.zoom, this.minTileCoordinate.x, this.minTileCoordinate.y);
        EastNorthCoordinate br = new EastNorthCoordinate(mapSpace, this.zoom, this.maxTileCoordinate.x, this.maxTileCoordinate.y);
        StringWriter sw = new StringWriter(1024);
        sw.write("<html>");
        sw.write("<b>Polygonal Map</b><br>");
        sw.write("Map source: " + this.mapSource.getName() + "<br>");
        sw.write("Zoom level: " + this.zoom + "<br>");
        sw.write("Polygon points: " + this.polygon.npoints + "<br>");
        sw.write("Area start: " + tl + " (" + this.minTileCoordinate.x + " / " + this.minTileCoordinate.y + ")<br>");
        sw.write("Area end: " + br + " (" + this.maxTileCoordinate.x + " / " + this.maxTileCoordinate.y + ")<br>");
        sw.write("Map size: " + (this.maxTileCoordinate.x - this.minTileCoordinate.x + 1) + "x" + (this.maxTileCoordinate.y - this.minTileCoordinate.y + 1) + " pixel<br>");
        if (this.parameters != null) {
            sw.write("Tile size: " + this.parameters.getWidth() + "x" + this.parameters.getHeight() + "<br>");
            sw.write("Tile format: " + (Object)((Object)this.parameters.getFormat()) + "<br>");
        } else {
            sw.write("Tile size: 256x256 (no processing)<br>");
        }
        sw.write("Maximum tiles to download: " + this.calculateTilesToDownload() + "<br>");
        sw.write("</html>");
        return sw.toString();
    }

    @Override
    public Enumeration<JobDispatcher.Job> getDownloadJobs(TarIndexedArchive tileArchive, DownloadJobListener listener) {
        if (this.mapSource instanceof MultiLayerMapSource) {
            return new DJEMultiLayer(this, tileArchive, listener);
        }
        return new DJEPolygon(this, tileArchive, listener);
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public MapInterface deepClone(LayerInterface newLayer) {
        MapPolygon map = (MapPolygon)super.deepClone(newLayer);
        map.polygon = new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
        return map;
    }
}

