/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Point;
import mobac.mapsources.MultiLayerMapSource;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MercatorPixelCoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class MapSelection {
    public static final int LAT_MAX = 85;
    public static final int LAT_MIN = -85;
    public static final int LON_MAX = 179;
    public static final int LON_MIN = -179;
    private final MapSource mapSource;
    private final MapSpace mapSpace;
    private final int mapSourceTileSize;
    private final int zoom;
    private int minTileCoordinate_x;
    private int minTileCoordinate_y;
    private int maxTileCoordinate_x;
    private int maxTileCoordinate_y;

    public MapSelection(MapSource mapSource, EastNorthCoordinate max, EastNorthCoordinate min) {
        this.mapSource = mapSource;
        this.mapSpace = mapSource.getMapSpace();
        this.mapSourceTileSize = this.mapSpace.getTileSize();
        this.zoom = 22;
        int x1 = this.mapSpace.cLonToX(min.lon, this.zoom);
        int x2 = this.mapSpace.cLonToX(max.lon, this.zoom);
        int y1 = this.mapSpace.cLatToY(min.lat, this.zoom);
        int y2 = this.mapSpace.cLatToY(max.lat, this.zoom);
        this.setCoordinates(x1, x2, y1, y2);
    }

    public MapSelection(MapInterface map) {
        this(map.getMapSource(), map.getMaxTileCoordinate(), map.getMinTileCoordinate(), map.getZoom());
    }

    public MapSelection(MapSource mapSource, Point p1, Point p2, int zoom) {
        this.mapSource = mapSource;
        this.mapSpace = mapSource.getMapSpace();
        this.mapSourceTileSize = this.mapSpace.getTileSize();
        this.zoom = zoom;
        this.setCoordinates(p1.x, p2.x, p1.y, p2.y);
    }

    public MapSelection(MapSource mapSource, MercatorPixelCoordinate c1, MercatorPixelCoordinate c2) {
        if (c1.getZoom() != c2.getZoom()) {
            throw new RuntimeException("Different zoom levels - unsuported!");
        }
        this.mapSource = mapSource;
        this.mapSpace = mapSource.getMapSpace();
        this.mapSourceTileSize = this.mapSpace.getTileSize();
        this.zoom = c1.getZoom();
        this.setCoordinates(c1.getX(), c2.getX(), c1.getY(), c2.getY());
    }

    protected void setCoordinates(int x1, int x2, int y1, int y2) {
        this.maxTileCoordinate_x = Math.max(x1, x2);
        this.minTileCoordinate_x = Math.min(x1, x2);
        this.maxTileCoordinate_y = Math.max(y1, y2);
        this.minTileCoordinate_y = Math.min(y1, y2);
    }

    public boolean isAreaSelected() {
        boolean result = this.maxTileCoordinate_x != this.minTileCoordinate_x && this.maxTileCoordinate_y != this.minTileCoordinate_y;
        return result;
    }

    public EastNorthCoordinate getMax() {
        return new EastNorthCoordinate(this.mapSpace, this.zoom, this.maxTileCoordinate_x, this.minTileCoordinate_y);
    }

    public EastNorthCoordinate getMin() {
        return new EastNorthCoordinate(this.mapSpace, this.zoom, this.minTileCoordinate_x, this.maxTileCoordinate_y);
    }

    public Point getTopLeftTileNumber(int aZoomlevel) {
        Point tlc = this.getTopLeftPixelCoordinate(aZoomlevel);
        tlc.x /= this.mapSourceTileSize;
        tlc.y /= this.mapSourceTileSize;
        return tlc;
    }

    public MercatorPixelCoordinate getTopLeftPixelCoordinate() {
        return new MercatorPixelCoordinate(this.mapSpace, this.minTileCoordinate_x, this.minTileCoordinate_y, this.zoom);
    }

    public Point getTopLeftPixelCoordinate(int aZoomlevel) {
        int zoomDiff = this.zoom - aZoomlevel;
        int x = this.minTileCoordinate_x;
        int y = this.minTileCoordinate_y;
        if (zoomDiff < 0) {
            zoomDiff = -zoomDiff;
            x <<= zoomDiff;
            y <<= zoomDiff;
        } else {
            x >>= zoomDiff;
            y >>= zoomDiff;
        }
        return new Point(x, y);
    }

    public Point getBottomRightTileNumber(int aZoomlevel) {
        Point brc = this.getBottomRightPixelCoordinate(aZoomlevel);
        brc.x /= this.mapSourceTileSize;
        brc.y /= this.mapSourceTileSize;
        return brc;
    }

    public MercatorPixelCoordinate getBottomRightPixelCoordinate() {
        return new MercatorPixelCoordinate(this.mapSpace, this.maxTileCoordinate_x, this.maxTileCoordinate_y, this.zoom);
    }

    public Point getBottomRightPixelCoordinate(int aZoomlevel) {
        int zoomDiff = this.zoom - aZoomlevel;
        int x = this.maxTileCoordinate_x;
        int y = this.maxTileCoordinate_y;
        if (zoomDiff < 0) {
            zoomDiff = -zoomDiff;
            x <<= zoomDiff;
            y <<= zoomDiff;
        } else {
            x >>= zoomDiff;
            y >>= zoomDiff;
        }
        return new Point(x, y);
    }

    public long calculateNrOfTiles(int zoom) {
        Point max = this.getBottomRightTileNumber(zoom);
        Point min = this.getTopLeftTileNumber(zoom);
        long width = max.x - min.x + 1;
        long height = max.y - min.y + 1;
        long tileCount = width * height;
        if (this.mapSource instanceof MultiLayerMapSource) {
            tileCount *= 2L;
        }
        return tileCount;
    }

    public long[] calculateNrOfTilesEx(int zoom) {
        Point max = this.getBottomRightTileNumber(zoom);
        Point min = this.getTopLeftTileNumber(zoom);
        long width = max.x - min.x + 1;
        long height = max.y - min.y + 1;
        long tileCount = width * height;
        if (this.mapSource instanceof MultiLayerMapSource) {
            tileCount *= 2L;
        }
        return new long[]{tileCount, width, height};
    }

    public String toString() {
        EastNorthCoordinate max = this.getMax();
        EastNorthCoordinate min = this.getMin();
        return String.format("lat/lon: max(%6f/%6f) min(%6f/%6f)", max.lat, max.lon, min.lat, min.lon);
    }
}

