/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import mobac.program.model.EastNorthCoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class MercatorPixelCoordinate {
    private final MapSpace mapSpace;
    private final int x;
    private final int y;
    private final int zoom;

    public MercatorPixelCoordinate(MapSpace mapSpace, int x, int y, int zoom) {
        this.mapSpace = mapSpace;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public MercatorPixelCoordinate(MapSpace mapSpace, double lat, double lon) {
        this.mapSpace = mapSpace;
        this.x = mapSpace.cLonToX(lon, 22);
        this.y = mapSpace.cLatToY(lat, 22);
        this.zoom = 22;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoom() {
        return this.zoom;
    }

    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    public EastNorthCoordinate getEastNorthCoordinate() {
        double lon = this.mapSpace.cXToLon(this.x, this.zoom);
        double lat = this.mapSpace.cYToLat(this.y, this.zoom);
        return new EastNorthCoordinate(lat, lon);
    }

    public MercatorPixelCoordinate adaptToZoomlevel(int aZoomlevel) {
        int zoomDiff = this.zoom - aZoomlevel;
        int new_x = this.x;
        int new_y = this.y;
        if (zoomDiff < 0) {
            zoomDiff = -zoomDiff;
            new_x <<= zoomDiff;
            new_y <<= zoomDiff;
        } else {
            new_x >>= zoomDiff;
            new_y >>= zoomDiff;
        }
        return new MercatorPixelCoordinate(this.mapSpace, new_x, new_y, aZoomlevel);
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " zoom=" + this.zoom;
    }
}

