/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import mobac.program.DirectoryManager;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.model.Atlas;
import mobac.utilities.Utilities;

public class Profile
implements Comparable<Profile> {
    public static final String PROFILE_NAME_REGEX = "[\\w _-]+";
    private static final Pattern PROFILE_FILENAME_PATTERN = Pattern.compile("mobac-profile-([\\w _-]+).xml");
    private File file;
    private String name;
    private static Vector<Profile> profiles = new Vector();

    public static void updateProfiles() {
        File profilesDir = DirectoryManager.currentDir;
        final HashSet<Profile> deletedProfiles = new HashSet<Profile>();
        deletedProfiles.addAll(profiles);
        profilesDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                Matcher m = PROFILE_FILENAME_PATTERN.matcher(fileName);
                if (m.matches()) {
                    String profileName = m.group(1);
                    Profile profile = new Profile(new File(dir, fileName), profileName);
                    deletedProfiles.remove(profile);
                    profiles.add(profile);
                }
                return false;
            }
        });
        for (Profile p : deletedProfiles) {
            profiles.remove(p);
        }
    }

    public static Vector<Profile> getProfiles() {
        Profile.updateProfiles();
        return profiles;
    }

    public Profile(String name) {
        this.file = new File(DirectoryManager.currentDir, "mobac-profile-" + name + ".xml");
        this.name = name;
    }

    protected Profile(File file, String name) {
        this.file = file;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        return this.file.isFile();
    }

    public void delete() {
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }

    @Override
    public int compareTo(Profile o) {
        return this.file.compareTo(o.file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile p = (Profile)obj;
        return this.file.equals(p.file);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return -1;
    }

    public void save(AtlasInterface atlasInterface) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Atlas.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.file);
            marshaller.marshal((Object)atlasInterface, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new JAXBException((Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fileOutputStream);
                throw throwable;
            }
        }
        Utilities.closeStream(fileOutputStream);
    }

    public AtlasInterface load() throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Atlas.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        AtlasInterface atlasInterface = (AtlasInterface)unmarshaller.unmarshal(this.file);
        return atlasInterface;
    }

    public static boolean checkAtlas(AtlasInterface atlasInterface) {
        return Profile.checkAtlasObject(atlasInterface);
    }

    private static boolean checkAtlasObject(Object o) {
        boolean result = false;
        if (o instanceof AtlasObject) {
            result |= ((AtlasObject)o).checkData();
        }
        if (o instanceof Iterable) {
            Iterable it = (Iterable)o;
            for (Object ao : it) {
                result |= Profile.checkAtlasObject(ao);
            }
        }
        return result;
    }
}

