/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import javax.swing.JCheckBox;

public class SelectedZoomLevels {
    private boolean[] zoomLevels;
    private int nrOfLayers;

    public SelectedZoomLevels(int minZoom, JCheckBox[] zoomCheckboxes) {
        this(minZoom + zoomCheckboxes.length);
        for (int i = 0; i < zoomCheckboxes.length; ++i) {
            if (!zoomCheckboxes[i].isSelected()) continue;
            this.setZoomLevelSelected(minZoom + i);
        }
    }

    public SelectedZoomLevels(int zommLevelCount) {
        this.zoomLevels = new boolean[zommLevelCount];
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            this.zoomLevels[i] = false;
        }
        this.nrOfLayers = 0;
    }

    public void setZoomLevelSelected(int zoomLevel) {
        this.zoomLevels[zoomLevel] = true;
        ++this.nrOfLayers;
    }

    public int[] getZoomLevels() {
        int[] result = new int[this.nrOfLayers];
        int j = 0;
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            if (!this.zoomLevels[i]) continue;
            result[j++] = i;
        }
        return result;
    }

    public int getNrOfLayers() {
        return this.nrOfLayers;
    }

    public String toString() {
        String r = "";
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            if (!this.zoomLevels[i]) continue;
            r = r + " " + i + ",";
        }
        if ((r = r.trim()).length() > 0) {
            r = r.substring(0, r.length() - 1);
        }
        return r;
    }
}

