/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.gui.mapview.ScaleBar;
import mobac.mapsources.CustomMapSource;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.impl.Google;
import mobac.program.DirectoryManager;
import mobac.program.ProgramInfo;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.CoordinateStringFormat;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.ProxyType;
import mobac.program.model.TileImageFormat;
import mobac.program.model.UnitSystem;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

@XmlRootElement
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public class Settings {
    private static Logger log = Logger.getLogger(Settings.class);
    private static Settings instance = new Settings();
    public static final File FILE = new File(DirectoryManager.currentDir, "settings.xml");
    private static long SETTINGS_LAST_MODIFIED = 0L;
    private static final String SYSTEM_PROXY_HOST = System.getProperty("http.proxyHost");
    private static final String SYSTEM_PROXY_PORT = System.getProperty("http.proxyPort");
    @XmlElement(defaultValue="")
    private String version;
    public int maxMapSize = Short.MAX_VALUE;
    public boolean tileStoreEnabled = true;
    public int mapviewZoom = 3;
    public int mapviewGridZoom = -1;
    public EastNorthCoordinate mapviewCenterCoordinate = new EastNorthCoordinate(50.0, 9.0);
    public Point mapviewSelectionMax = null;
    public Point mapviewSelectionMin = null;
    @XmlElement(nillable=false)
    public String mapviewMapSource = MapSourcesManager.DEFAULT.getName();
    public String elementName = "Layer name";
    private String userAgent = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5";
    public int downloadThreadCount = 4;
    private boolean customTileProcessing = false;
    private Dimension tileSize = new Dimension(256, 256);
    private TileImageFormat tileImageFormat = TileImageFormat.PNG;
    private AtlasOutputFormat atlasOutputFormat = AtlasOutputFormat.TaredAtlas;
    public CoordinateStringFormat coordinateNumberFormat = CoordinateStringFormat.DEG_LOCAL;
    @XmlElement
    private String atlasOutputDirectory = null;
    public String tileStoreDirectory;
    public int httpConnectionTimeout = 10;
    public int httpReadTimeout = 10;
    public long tileMaxExpirationTime = TimeUnit.DAYS.toMillis(365L);
    public long tileMinExpirationTime = TimeUnit.DAYS.toMillis(1L);
    public long tileDefaultExpirationTime = TimeUnit.DAYS.toMillis(7L);
    private String googleLanguage = "en";
    @XmlElement
    private boolean devMode = false;
    public String gpxFileChooserDir = "";
    public final MainWindowSettings mainWindow = new MainWindowSettings();
    private ProxyType proxyType = ProxyType.SYSTEM;
    private String customProxyHost = "";
    private String customProxyPort = "";
    private Vector<String> disabledMapSources = new Vector();
    @XmlElementWrapper(name="customMapSources")
    @XmlElement(name="customMapSource")
    public Vector<CustomMapSource> customMapSources = new Vector();
    @XmlElement(name="MapSourcesUpdate")
    public final MapSourcesUpdate mapSourcesUpdate = new MapSourcesUpdate();

    private Settings() {
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainWindow.size.width = (int)(0.9f * (float)dScreen.width);
        this.mainWindow.size.height = (int)(0.9f * (float)dScreen.height);
        this.mainWindow.collapsedPanels.add("Coordinates");
        this.mainWindow.collapsedPanels.add("Gpx");
    }

    public static Settings getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws JAXBException {
        Object object;
        try {
            object = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Unmarshaller unmarshaller = object.createUnmarshaller();
            instance = (Settings)unmarshaller.unmarshal(FILE);
            SETTINGS_LAST_MODIFIED = FILE.lastModified();
        }
        finally {
            object = Settings.getInstance();
            ((Settings)object).applyProxySettings();
        }
    }

    public static boolean checkSettingsFileModified() {
        if (SETTINGS_LAST_MODIFIED == 0L) {
            return false;
        }
        long lastModified = FILE.lastModified();
        return SETTINGS_LAST_MODIFIED != lastModified;
    }

    public static void save() throws JAXBException {
        Settings.getInstance().version = ProgramInfo.getVersion();
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream byteArrayOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            marshaller.marshal((Object)Settings.getInstance(), (OutputStream)byteArrayOutputStream);
            fileOutputStream = new FileOutputStream(FILE);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.close();
            SETTINGS_LAST_MODIFIED = FILE.lastModified();
        }
        catch (IOException iOException) {
            try {
                throw new JAXBException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fileOutputStream);
                throw throwable;
            }
        }
        Utilities.closeStream(fileOutputStream);
    }

    public static void loadOrQuit() {
        try {
            Settings.load();
        }
        catch (JAXBException e) {
            log.error((Object)e);
            JOptionPane.showMessageDialog(null, "Could not read file settings.xml program will exit.", "Error", 0);
            System.exit(0);
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getGoogleLanguage() {
        return this.googleLanguage;
    }

    public void setGoogleLanguage(String googleLanguage) {
        this.googleLanguage = googleLanguage;
        Google.LANG = googleLanguage;
    }

    public boolean isCustomTileSize() {
        return this.customTileProcessing;
    }

    public void setCustomTileSize(boolean customTileSize) {
        this.customTileProcessing = customTileSize;
    }

    public Dimension getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Dimension tileSize) {
        this.tileSize = tileSize;
    }

    public boolean isDevModeEnabled() {
        return this.devMode;
    }

    public TileImageFormat getTileImageFormat() {
        return this.tileImageFormat;
    }

    public void setTileImageFormat(TileImageFormat tileImageFormat) {
        this.tileImageFormat = tileImageFormat;
    }

    public AtlasOutputFormat getAtlasOutputFormat() {
        return this.atlasOutputFormat;
    }

    public void setAtlasOutputFormat(AtlasOutputFormat atlasOutputFormat) {
        this.atlasOutputFormat = atlasOutputFormat;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public String getCustomProxyHost() {
        return this.customProxyHost;
    }

    public String getCustomProxyPort() {
        return this.customProxyPort;
    }

    public void setCustomProxyHost(String proxyHost) {
        this.customProxyHost = proxyHost;
    }

    public void setCustomProxyPort(String proxyPort) {
        this.customProxyPort = proxyPort;
    }

    public Vector<String> getDisabledMapSources() {
        return this.disabledMapSources;
    }

    @XmlElementWrapper(name="disabledMapSources")
    @XmlElement(name="mapSource")
    public void setDisabledMapSources(Vector<String> disabledMapSources) {
        this.disabledMapSources = disabledMapSources;
    }

    public void applyProxySettings() {
        String newProxyHost = null;
        String newProxyPort = null;
        switch (this.proxyType) {
            case SYSTEM: {
                System.setProperty("java.net.useSystemProxies", "true");
                log.info("Proxy configuration applied: system settings");
                return;
            }
            case APP_SETTINGS: {
                newProxyHost = SYSTEM_PROXY_HOST;
                newProxyPort = SYSTEM_PROXY_PORT;
                break;
            }
            case CUSTOM: {
                newProxyHost = this.customProxyHost;
                newProxyPort = this.customProxyPort;
            }
        }
        Utilities.setHttpProxyHost(newProxyHost);
        Utilities.setHttpProxyPort(newProxyPort);
        System.setProperty("java.net.useSystemProxies", "false");
        log.info("Proxy configuration applied: host=" + newProxyHost + " port=" + newProxyPort);
    }

    @XmlElement
    public void setUnitSystem(UnitSystem unitSystem) {
        if (unitSystem == null) {
            unitSystem = UnitSystem.Metric;
        }
        ScaleBar.unitSystem = unitSystem;
    }

    public UnitSystem getUnitSystem() {
        return ScaleBar.unitSystem;
    }

    public File getAtlasOutputDirectory() {
        if (this.atlasOutputDirectory != null) {
            return new File(this.atlasOutputDirectory);
        }
        return new File(DirectoryManager.currentDir, "atlases");
    }

    public String getAtlasOutputDirectoryString() {
        if (this.atlasOutputDirectory == null) {
            return "";
        }
        return this.atlasOutputDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAtlasOutputDirectory(String dir) {
        if (dir != null && dir.trim().length() == 0) {
            dir = null;
        }
        this.atlasOutputDirectory = dir;
    }

    public static class MapSourcesUpdate {
        public String etag;
        public Date lastUpdate;
    }

    public static class MainWindowSettings {
        public Dimension size = new Dimension();
        public Point position = new Point(-1, -1);
        public Boolean maximized = true;
        @XmlElementWrapper(name="collapsedPanels")
        @XmlElement(name="collapsedPanel")
        public Vector<String> collapsedPanels = new Vector();
    }
}

