/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import mobac.program.interfaces.TileImageDataWriter;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.program.tiledatawriter.TileImagePng4DataWriter;
import mobac.program.tiledatawriter.TileImagePng8DataWriter;
import mobac.program.tiledatawriter.TileImagePngDataWriter;

public enum TileImageFormat {
    PNG("PNG", new TileImagePngDataWriter()),
    PNG8Bit("PNG 256 colors (8 bit)", new TileImagePng8DataWriter()),
    PNG4Bit("PNG  16 colors (4 bit)", new TileImagePng4DataWriter()),
    JPEG100("JPEG - quality 100", new TileImageJpegDataWriter(1.0)),
    JPEG99("JPEG - quality 99", new TileImageJpegDataWriter(0.99)),
    JPEG95("JPEG - quality 95", new TileImageJpegDataWriter(0.95)),
    JPEG90("JPEG - quality 90", new TileImageJpegDataWriter(0.9)),
    JPEG85("JPEG - quality 85", new TileImageJpegDataWriter(0.85)),
    JPEG80("JPEG - quality 80", new TileImageJpegDataWriter(0.8)),
    JPEG70("JPEG - quality 70", new TileImageJpegDataWriter(0.7)),
    JPEG60("JPEG - quality 60", new TileImageJpegDataWriter(0.6)),
    JPEG50("JPEG - quality 50", new TileImageJpegDataWriter(0.5));

    private final String description;
    private final TileImageDataWriter dataWriter;

    private TileImageFormat(String description, TileImageDataWriter dataWriter) {
        this.description = description;
        this.dataWriter = dataWriter;
    }

    public String toString() {
        return this.description;
    }

    public TileImageDataWriter getDataWriter() {
        return this.dataWriter;
    }
}

