/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tiledatawriter;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import mobac.program.interfaces.TileImageDataWriter;
import org.apache.log4j.Logger;

public class TileImageJpegDataWriter
implements TileImageDataWriter {
    protected Logger log;
    protected ImageWriter jpegImageWriter = null;
    protected ImageWriteParam iwp = null;
    protected float jpegCompressionLevel;

    public TileImageJpegDataWriter(double jpegCompressionLevel) {
        this((float)jpegCompressionLevel);
    }

    public TileImageJpegDataWriter(float jpegCompressionLevel) {
        this.jpegCompressionLevel = jpegCompressionLevel;
        this.log = Logger.getLogger(this.getClass());
    }

    public TileImageJpegDataWriter(TileImageJpegDataWriter jpegWriter) {
        this(jpegWriter.getJpegCompressionLevel());
    }

    @Override
    public void initialize() {
        if (this.log.isTraceEnabled()) {
            String s = "Available JPEG image writers:";
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            while (writers.hasNext()) {
                ImageWriter w = writers.next();
                s = s + "\n\t" + w.getClass().getName();
            }
            this.log.trace(s);
        }
        this.jpegImageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
        this.log.debug("Used JPEG image writer: " + this.jpegImageWriter.getClass().getName());
        this.iwp = this.jpegImageWriter.getDefaultWriteParam();
        this.iwp.setCompressionMode(2);
        this.iwp.setCompressionQuality(this.jpegCompressionLevel);
    }

    public void setJpegCompressionLevel(float jpegCompressionLevel) {
        this.jpegCompressionLevel = jpegCompressionLevel;
        this.iwp.setCompressionQuality(jpegCompressionLevel);
    }

    public float getJpegCompressionLevel() {
        return this.jpegCompressionLevel;
    }

    @Override
    public void processImage(BufferedImage image, OutputStream out) throws IOException {
        this.jpegImageWriter.setOutput(ImageIO.createImageOutputStream(out));
        IIOImage ioImage = new IIOImage(image, null, null);
        this.jpegImageWriter.write(null, ioImage, this.iwp);
    }

    @Override
    public void dispose() {
        this.jpegImageWriter.dispose();
        this.jpegImageWriter = null;
    }

    @Override
    public String getFileExt() {
        return "jpg";
    }
}

