/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import mobac.exceptions.TileStoreException;
import mobac.program.DirectoryManager;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStoreEntry;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.BerkeleyDbTileStore;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public abstract class TileStore {
    private static TileStore INSTANCE = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected File tileStoreDir;

    public static void initialize() {
        try {
            INSTANCE = new BerkeleyDbTileStore();
        }
        catch (TileStoreException e) {
            String errMsg = "Multiple instances of Mobile Atlas Creator are trying to access the same tile store.\nThe tile store can only be used by used by one instance at a time.\nPlease close the other instance and try again.";
            JOptionPane.showMessageDialog(null, errMsg, "Multiple instances of Mobile Atlas Creator running", 0);
            System.exit(1);
        }
    }

    public static TileStore getInstance() {
        return INSTANCE;
    }

    protected TileStore() {
        String tileStorePath = Settings.getInstance().tileStoreDirectory;
        this.tileStoreDir = tileStorePath != null ? new File(tileStorePath) : new File(DirectoryManager.currentDir, "tilestore");
        this.log.debug("Tile store path: " + this.tileStoreDir);
    }

    public abstract void putTileData(byte[] var1, int var2, int var3, int var4, MapSource var5) throws IOException;

    public abstract void putTileData(byte[] var1, int var2, int var3, int var4, MapSource var5, long var6, long var8, String var10) throws IOException;

    public abstract TileStoreEntry getTile(int var1, int var2, int var3, MapSource var4);

    public abstract boolean contains(int var1, int var2, int var3, MapSource var4);

    public abstract void prepareTileStore(MapSource var1);

    public abstract void clearStore(MapSource var1);

    public abstract boolean storeExists(MapSource var1);

    public abstract TileStoreInfo getStoreInfo(MapSource var1) throws InterruptedException;

    public abstract void closeAll(boolean var1);

    public abstract void putTile(TileStoreEntry var1, MapSource var2);

    public abstract TileStoreEntry createNewEntry(int var1, int var2, int var3, byte[] var4, long var5, long var7, String var9);
}

