/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore.berkeleydb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import mobac.exceptions.TileStoreException;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.program.tilestore.berkeleydb.TileDbEntry;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import mobac.utilities.file.DeleteFileFilter;
import mobac.utilities.file.DirInfoFileFilter;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class BerkeleyDbTileStore
extends TileStore {
    private static final int MAX_CONCURRENT_ENVIRONMENTS = 5;
    private EnvironmentConfig envConfig;
    private Map<String, TileDatabase> tileDbMap;
    private FileLock tileStoreLock = null;
    private Mutations mutations;

    public BerkeleyDbTileStore() throws TileStoreException {
        this.acquireTileStoreLock();
        this.tileDbMap = new TreeMap<String, TileDatabase>();
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setTransactional(false);
        this.envConfig.setLocking(true);
        this.envConfig.setExceptionListener(GUIExceptionHandler.getInstance());
        this.envConfig.setAllowCreate(true);
        this.envConfig.setSharedCache(true);
        this.envConfig.setCachePercent(50);
        this.mutations = new Mutations();
        String string = "tac.tilestore.berkeleydb";
        String string2 = "tac.program.tilestore.berkeleydb";
        String string3 = ".TileDbEntry";
        String string4 = ".TileDbEntry$TileDbKey";
        this.mutations.addRenamer(new Renamer(string + string3, 0, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(string + string4, 0, TileDbEntry.TileDbKey.class.getName()));
        this.mutations.addRenamer(new Renamer(string + string3, 1, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(string + string4, 1, TileDbEntry.TileDbKey.class.getName()));
        this.mutations.addRenamer(new Renamer(string2 + string3, 2, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(string2 + string4, 2, TileDbEntry.TileDbKey.class.getName()));
    }

    protected void acquireTileStoreLock() throws TileStoreException {
        try {
            File file = new File(this.tileStoreDir, "lock");
            if (!this.tileStoreDir.isDirectory()) {
                try {
                    Utilities.mkDirs(this.tileStoreDir);
                }
                catch (IOException e) {
                    throw new TileStoreException("Unable to create tile store directory: \"" + this.tileStoreDir.getPath() + "\"");
                }
            }
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            this.tileStoreLock = channel.tryLock();
            if (this.tileStoreLock == null) {
                throw new TileStoreException("Unable to obtain tile store lock - another instance of Mobile Atlas Creator is running!");
            }
        }
        catch (Exception e) {
            this.log.error("", e);
            throw new TileStoreException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public TileStoreEntry createNewEntry(int x, int y, int zoom, byte[] data, long timeLastModified, long timeExpires, String eTag) {
        return new TileDbEntry(x, y, zoom, data, timeLastModified, timeExpires, eTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileDatabase getTileDatabase(MapSource mapSource) throws DatabaseException {
        TileDatabase db;
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            db = this.tileDbMap.get(mapSource.getStoreName());
        }
        if (db != null) {
            return db;
        }
        try {
            map = this.tileDbMap;
            synchronized (map) {
                this.cleanupDatabases();
                db = this.tileDbMap.get(mapSource.getStoreName());
                if (db == null) {
                    db = new TileDatabase(mapSource);
                    db.lastAccess = System.currentTimeMillis();
                    this.tileDbMap.put(mapSource.getStoreName(), db);
                }
                return db;
            }
        }
        catch (Exception e) {
            this.log.error("Error creating tile store db \"" + mapSource.getStoreName() + "\"", e);
            throw new TileStoreException(e);
        }
    }

    @Override
    public TileStoreInfo getStoreInfo(MapSource mapSource) throws InterruptedException {
        int tileCount = this.getNrOfTiles(mapSource);
        long storeSize = this.getStoreSize(mapSource);
        return new TileStoreInfo(storeSize, tileCount);
    }

    @Override
    public void putTileData(byte[] tileData, int x, int y, int zoom, MapSource mapSource) throws IOException {
        this.putTileData(tileData, x, y, zoom, mapSource, -1L, -1L, null);
    }

    @Override
    public void putTileData(byte[] tileData, int x, int y, int zoom, MapSource mapSource, long timeLastModified, long timeExpires, String eTag) throws IOException {
        if (!mapSource.allowFileStore()) {
            return;
        }
        TileDbEntry tile = new TileDbEntry(x, y, zoom, tileData, timeLastModified, timeExpires, eTag);
        TileDatabase db = null;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Saved " + mapSource.getStoreName() + " " + tile);
            }
            db = this.getTileDatabase(mapSource);
            db.put(tile);
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("Faild to write tile to tile store \"" + mapSource.getStoreName() + "\"", e);
        }
    }

    @Override
    public void putTile(TileStoreEntry tile, MapSource mapSource) {
        if (!mapSource.allowFileStore()) {
            return;
        }
        TileDatabase db = null;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Saved " + mapSource.getStoreName() + " " + tile);
            }
            db = this.getTileDatabase(mapSource);
            db.put((TileDbEntry)tile);
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("Faild to write tile to tile store \"" + mapSource.getStoreName() + "\"", e);
        }
    }

    @Override
    public TileStoreEntry getTile(int x, int y, int zoom, MapSource mapSource) {
        if (!mapSource.allowFileStore()) {
            return null;
        }
        TileDatabase db = null;
        try {
            db = this.getTileDatabase(mapSource);
            TileDbEntry tile = db.get(new TileDbEntry.TileDbKey(x, y, zoom));
            if (this.log.isTraceEnabled()) {
                if (tile == null) {
                    this.log.trace("Tile store cache miss: (x,y,z)" + x + "/" + y + "/" + zoom + " " + mapSource.getStoreName());
                } else {
                    this.log.trace("Loaded " + mapSource.getStoreName() + " " + tile);
                }
            }
            return tile;
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("failed to retrieve tile from tile store \"" + mapSource.getStoreName() + "\"", e);
            return null;
        }
    }

    @Override
    public boolean contains(int x, int y, int zoom, MapSource mapSource) {
        try {
            return this.getTileDatabase(mapSource).contains(new TileDbEntry.TileDbKey(x, y, zoom));
        }
        catch (DatabaseException e) {
            this.log.error("", e);
            return false;
        }
    }

    @Override
    public void prepareTileStore(MapSource mapSource) {
        if (!mapSource.allowFileStore()) {
            return;
        }
        try {
            this.getTileDatabase(mapSource);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStore(MapSource mapSource) {
        File databaseDir = this.getStoreDir(mapSource);
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            TileDatabase db = this.tileDbMap.get(mapSource.getStoreName());
            if (db != null) {
                db.close(false);
            }
            if (databaseDir.exists()) {
                DeleteFileFilter dff = new DeleteFileFilter();
                databaseDir.listFiles(dff);
                databaseDir.delete();
                this.log.debug("Tilestore " + mapSource.getStoreName() + " cleared: " + dff);
            }
            this.tileDbMap.remove(mapSource.getStoreName());
        }
    }

    public int getNrOfTiles(MapSource mapSource) throws InterruptedException {
        try {
            File storeDir = this.getStoreDir(mapSource);
            if (!storeDir.isDirectory()) {
                return 0;
            }
            TileDatabase db = this.getTileDatabase(mapSource);
            int tileCount = (int)db.entryCount();
            db.close();
            return tileCount;
        }
        catch (DatabaseException e) {
            this.log.error("", e);
            return -1;
        }
    }

    public long getStoreSize(MapSource mapSource) throws InterruptedException {
        File tileStore = this.getStoreDir(mapSource);
        if (tileStore.exists()) {
            DirInfoFileFilter diff = new DirInfoFileFilter();
            try {
                tileStore.listFiles(diff);
            }
            catch (RuntimeException e) {
                throw new InterruptedException();
            }
            return diff.getDirSize();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDatabases() {
        if (this.tileDbMap.size() < 5) {
            return;
        }
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            ArrayList<TileDatabase> list = new ArrayList<TileDatabase>(this.tileDbMap.values());
            Collections.sort(list, new Comparator<TileDatabase>(){

                @Override
                public int compare(TileDatabase o1, TileDatabase o2) {
                    if (o1.lastAccess == o2.lastAccess) {
                        return 0;
                    }
                    return o1.lastAccess < o2.lastAccess ? -1 : 1;
                }
            });
            for (int i = 0; i < list.size() - 2; ++i) {
                ((TileDatabase)list.get(i)).close();
            }
        }
    }

    @Override
    public void closeAll(final boolean shutdown) {
        DelayedInterruptThread t = new DelayedInterruptThread("DBShutdown"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BerkeleyDbTileStore.this.log.debug("Closing all tile databases...");
                Map map = BerkeleyDbTileStore.this.tileDbMap;
                synchronized (map) {
                    for (TileDatabase db : BerkeleyDbTileStore.this.tileDbMap.values()) {
                        db.close(false);
                    }
                    BerkeleyDbTileStore.this.tileDbMap.clear();
                    if (shutdown) {
                        BerkeleyDbTileStore.this.tileDbMap = null;
                        try {
                            BerkeleyDbTileStore.this.tileStoreLock.release();
                        }
                        catch (IOException e) {
                            BerkeleyDbTileStore.this.log.error("", e);
                        }
                    }
                }
                BerkeleyDbTileStore.this.log.debug("All tile databases has been closed");
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            this.log.error("", e);
        }
    }

    @Override
    public boolean storeExists(MapSource mapSource) {
        File tileStore = this.getStoreDir(mapSource);
        return tileStore.isDirectory() && tileStore.exists();
    }

    protected File getStoreDir(MapSource mapSource) {
        return new File(this.tileStoreDir, "db-" + mapSource.getStoreName());
    }

    protected class TileDatabase {
        final MapSource mapSource;
        final Environment env;
        final EntityStore store;
        final PrimaryIndex<TileDbEntry.TileDbKey, TileDbEntry> tileIndex;
        boolean dbClosed = false;
        long lastAccess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileDatabase(MapSource mapSource) throws IOException, EnvironmentLockedException, DatabaseException {
            BerkeleyDbTileStore.this.log.debug("Opening tile store db: \"" + mapSource.getStoreName() + "\"");
            DelayedInterruptThread delayedInterruptThread = (DelayedInterruptThread)Thread.currentThread();
            try {
                delayedInterruptThread.pauseInterrupt();
                this.mapSource = mapSource;
                this.lastAccess = System.currentTimeMillis();
                File file = BerkeleyDbTileStore.this.getStoreDir(mapSource);
                Utilities.mkDirs(file);
                this.env = new Environment(file, BerkeleyDbTileStore.this.envConfig);
                StoreConfig storeConfig = new StoreConfig();
                storeConfig.setAllowCreate(true);
                storeConfig.setTransactional(false);
                storeConfig.setMutations(BerkeleyDbTileStore.this.mutations);
                this.store = new EntityStore(this.env, "TilesEntityStore", storeConfig);
                this.tileIndex = this.store.getPrimaryIndex(TileDbEntry.TileDbKey.class, TileDbEntry.class);
            }
            finally {
                if (delayedInterruptThread.interruptedWhilePaused()) {
                    this.close();
                }
                delayedInterruptThread.resumeInterrupt();
            }
            BerkeleyDbTileStore.this.log.debug("Opened tile store db: \"" + mapSource.getStoreName() + "\"");
        }

        public boolean isClosed() {
            return this.dbClosed;
        }

        public long entryCount() throws DatabaseException {
            return this.tileIndex.count();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(TileDbEntry tile) throws DatabaseException {
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            try {
                t.pauseInterrupt();
                this.tileIndex.put(tile);
            }
            finally {
                if (t.interruptedWhilePaused()) {
                    this.close();
                }
                t.resumeInterrupt();
            }
        }

        public boolean contains(TileDbEntry.TileDbKey key) throws DatabaseException {
            return this.tileIndex.contains(key);
        }

        public TileDbEntry get(TileDbEntry.TileDbKey key) throws DatabaseException {
            return this.tileIndex.get(key);
        }

        protected void purge() {
            try {
                this.store.sync();
                this.env.cleanLog();
            }
            catch (DatabaseException e) {
                BerkeleyDbTileStore.this.log.error("database compression failed: ", e);
            }
        }

        public void close() {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean removeFromMap) {
            if (this.dbClosed) {
                return;
            }
            if (removeFromMap) {
                Map map = BerkeleyDbTileStore.this.tileDbMap;
                synchronized (map) {
                    TileDatabase db2 = (TileDatabase)BerkeleyDbTileStore.this.tileDbMap.get(this.mapSource.getStoreName());
                    if (db2 == this) {
                        BerkeleyDbTileStore.this.tileDbMap.remove(this.mapSource.getStoreName());
                    }
                }
            }
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            try {
                t.pauseInterrupt();
                try {
                    BerkeleyDbTileStore.this.log.debug("Closing tile store db \"" + this.mapSource.getStoreName() + "\"");
                    if (this.store != null) {
                        this.store.close();
                    }
                }
                catch (Exception e) {
                    BerkeleyDbTileStore.this.log.error("", e);
                }
                try {
                    this.env.close();
                }
                catch (Exception e) {
                    BerkeleyDbTileStore.this.log.error("", e);
                }
                finally {
                    this.dbClosed = true;
                }
            }
            finally {
                if (t.interruptedWhilePaused()) {
                    this.close();
                }
                t.resumeInterrupt();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

