/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import com.sleepycat.je.ExceptionEvent;
import com.sleepycat.je.ExceptionListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import mobac.mapsources.MapSourcesUpdater;
import mobac.program.ProgramInfo;
import mobac.utilities.OSUtilities;
import org.apache.log4j.Logger;

public class GUIExceptionHandler
implements ExceptionListener,
Thread.UncaughtExceptionHandler {
    private static final GUIExceptionHandler instance = new GUIExceptionHandler();
    private static final Logger log = Logger.getLogger(GUIExceptionHandler.class);

    public static void registerForCurrentThread() {
        Thread t = Thread.currentThread();
        log.trace("Registering MOBAC exception handler for thread \"" + t.getName() + "\" [" + t.getId() + "]");
        t.setUncaughtExceptionHandler(instance);
    }

    public static GUIExceptionHandler getInstance() {
        return instance;
    }

    private GUIExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        GUIExceptionHandler.processException(t, e);
    }

    public static void processException(Throwable e) {
        GUIExceptionHandler.processException(Thread.currentThread(), e);
    }

    public static void processException(Thread thread, Throwable t) {
        log.error("Uncaught exception: ", t);
        GUIExceptionHandler.showExceptionDialog(thread, t, null);
    }

    @Override
    public void exceptionThrown(ExceptionEvent paramExceptionEvent) {
        Exception e = paramExceptionEvent.getException();
        log.error("Exception in tile store: " + paramExceptionEvent.toString(), e);
        GUIExceptionHandler.showExceptionDialog(e);
    }

    public static String prop(String key) {
        String s = System.getProperty(key);
        if (s != null) {
            return s;
        }
        return "";
    }

    public static void showExceptionDialog(Throwable t) {
        GUIExceptionHandler.showExceptionDialog(t, null);
    }

    public static void showExceptionDialog(Thread thread, Throwable t, String additionalInfo) {
        String threadInfo = "Thread: " + thread.getName() + "\n";
        additionalInfo = additionalInfo != null ? threadInfo + additionalInfo : threadInfo;
        GUIExceptionHandler.showExceptionDialog(t, additionalInfo);
    }

    public static void showExceptionDialog(Throwable throwable, String string) {
        String string2 = throwable.getClass().getSimpleName();
        try {
            Object object;
            Object object2;
            String string3;
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append("Version: " + ProgramInfo.getCompleteTitle());
            stringBuilder.append("\nPlatform: " + GUIExceptionHandler.prop("os.name") + " (" + GUIExceptionHandler.prop("os.version") + ")");
            String string4 = System.getProperty("sun.desktop");
            if (string4 != null) {
                stringBuilder.append(" (" + string4 + ")");
            }
            if ((string3 = OSUtilities.getLinuxDistributionName()) != null) {
                stringBuilder.append("\nDistribution name: " + string3);
            }
            stringBuilder.append("\nJava VM: " + GUIExceptionHandler.prop("java.vm.name") + " (" + GUIExceptionHandler.prop("java.runtime.version") + ")");
            if (throwable.getClass().equals(OutOfMemoryError.class)) {
                object2 = Runtime.getRuntime();
                stringBuilder.append(String.format("\nMax heap size: %3.2f MiB", (double)((Runtime)object2).maxMemory() / 1048576.0));
            }
            stringBuilder.append("\nMapsources rev: " + MapSourcesUpdater.getMapSourcesRev(System.getProperties()));
            if (string != null) {
                stringBuilder.append("\n\n" + string);
            }
            stringBuilder.append("\n\nError hierarchy:");
            for (object2 = throwable; object2 != null; object2 = ((Throwable)object2).getCause()) {
                stringBuilder.append("\n  " + object2.getClass().getSimpleName() + ": " + ((Throwable)object2).getMessage());
            }
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuilder.append("\n\n#############################################################\n\n");
            stringBuilder.append(stringWriter.getBuffer().toString());
            stringBuilder.append("\n#############################################################");
            JPanel jPanel = new JPanel(new BorderLayout());
            String string5 = "http://sourceforge.net/tracker/?group_id=238075&atid=1105494";
            String string6 = "An unexpected exception occurred (" + string2 + ")<br>" + "<p>Please report a ticket in the bug tracker " + "on <a href=\"" + string5 + "\">SourceForge.net</a><br>" + "<b>Please include a detailed description of your performed actions <br>" + "before the error occurred.</b></p>" + "Be sure to include the following information:";
            JEditorPane jEditorPane = new JEditorPane("text/html", "");
            jEditorPane.setOpaque(true);
            jEditorPane.setBackground(UIManager.getColor("JFrame.background"));
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        log.error("", e1);
                    }
                }
            });
            jPanel.add((Component)jEditorPane, "North");
            try {
                object = new StringSelection(stringBuilder.toString());
                ClipboardOwner clipboardOwner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, clipboardOwner);
                string6 = string6 + "<p>(The following text has already been copied to your clipboard.)</p>";
            }
            catch (RuntimeException runtimeException) {
                log.error("", runtimeException);
            }
            jEditorPane.setText("<html>" + string6 + "</html>");
            object = new JTextArea(stringBuilder.toString(), 20, 60);
            ((JTextComponent)object).setCaretPosition(0);
            ((JTextComponent)object).setEditable(false);
            ((JComponent)object).setMinimumSize(new Dimension(200, 150));
            jPanel.add((Component)new JScrollPane((Component)object), "Center");
            jPanel.setMinimumSize(new Dimension(700, 300));
            jPanel.validate();
            JOptionPane.showMessageDialog(null, jPanel, "Unexpected Exception: " + string2, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void installToolkitEventQueueProxy() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.push(new EventQueueProxy());
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(instance);
    }

    protected static class EventQueueProxy
    extends EventQueue {
        protected EventQueueProxy() {
        }

        @Override
        protected void dispatchEvent(AWTEvent newEvent) {
            try {
                super.dispatchEvent(newEvent);
            }
            catch (Throwable e) {
                StackTraceElement[] st;
                if (e instanceof ArrayIndexOutOfBoundsException && (st = e.getStackTrace()).length > 0 && "sun.font.FontDesignMetrics".equals(st[0].getClassName())) {
                    log.error("Ignored JRE bug exception " + e.getMessage() + " caused by : " + st[0]);
                    return;
                }
                GUIExceptionHandler.processException(Thread.currentThread(), e);
            }
        }
    }
}

