/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import mobac.Main;
import mobac.utilities.file.DirectoryFileFilter;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class Utilities {
    public static final DecimalFormatSymbols DFS_ENG = new DecimalFormatSymbols(Locale.ENGLISH);
    public static final DecimalFormatSymbols DFS_LOCAL = new DecimalFormatSymbols();
    public static final DecimalFormat FORMAT_6_DEC = new DecimalFormat("#0.######");
    public static final DecimalFormat FORMAT_6_DEC_ENG = new DecimalFormat("#0.######", DFS_ENG);
    public static final DecimalFormat FORMAT_2_DEC = new DecimalFormat("0.00");
    private static final DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static final DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static final Logger log = Logger.getLogger(Utilities.class);
    public static final long SECONDS_PER_HOUR = TimeUnit.HOURS.toSeconds(1L);
    public static final long SECONDS_PER_DAY = TimeUnit.DAYS.toSeconds(1L);
    private static final byte[] PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] JPG = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70};
    private static final byte[] GIF_1 = "GIF87a".getBytes();
    private static final byte[] GIF_2 = "GIF89a".getBytes();

    public static boolean testJaiColorQuantizerAvailable() {
        try {
            Class<?> c = Class.forName("javax.media.jai.operator.ColorQuantizerDescriptor");
            if (c != null) {
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable t) {
            log.error("Error in testJaiColorQuantizerAvailable():", t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createEmptyTileImage(MapSource mapSource) {
        int tileSize = mapSource.getMapSpace().getTileSize();
        Color color = mapSource.getBackgroundColor();
        BufferedImage emptyImage = new BufferedImage(tileSize, tileSize, 1);
        Graphics2D g = emptyImage.createGraphics();
        try {
            g.setColor(color);
            g.fillRect(0, 0, tileSize, tileSize);
        }
        finally {
            g.dispose();
        }
        return emptyImage;
    }

    public static byte[] createEmptyTileData(MapSource mapSource) {
        BufferedImage emptyImage = Utilities.createEmptyTileImage(mapSource);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
        try {
            ImageIO.write((RenderedImage)emptyImage, mapSource.getTileType(), buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] emptyTileData = buf.toByteArray();
        return emptyTileData;
    }

    public static String getImageDataFormat(byte[] imageData) {
        if (Utilities.startsWith(imageData, PNG)) {
            return "png";
        }
        if (Utilities.startsWith(imageData, JPG)) {
            return "jpg";
        }
        if (Utilities.startsWith(imageData, GIF_1) || Utilities.startsWith(imageData, GIF_2)) {
            return "gif";
        }
        return null;
    }

    public static boolean startsWith(byte[] data, byte[] startTest) {
        if (data.length < startTest.length) {
            return false;
        }
        for (int i = 0; i < startTest.length; ++i) {
            if (data[i] == startTest[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean checkJAXBVersion() {
        try {
            Class<?> c = Class.forName("javax.xml.bind.JAXB");
            return c != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static InputStream loadResourceAsStream(String string) throws IOException {
        return Main.class.getResourceAsStream("resources/" + string);
    }

    public static ImageIcon loadResourceImageIcon(String string) {
        URL uRL = Main.class.getResource("resources/images/" + string);
        return new ImageIcon(uRL);
    }

    public static URL getResourceImageUrl(String string) {
        return Main.class.getResource("resources/images/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties p, URL url) throws IOException {
        InputStream propIn = url.openStream();
        try {
            p.load(propIn);
        }
        finally {
            Utilities.closeStream(propIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties p, File f) throws IOException {
        FileInputStream propIn = new FileInputStream(f);
        try {
            p.load(propIn);
        }
        finally {
            Utilities.closeStream(propIn);
        }
    }

    public static void checkForInterruption() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    public static void checkForInterruptionRt() throws RuntimeException {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
    }

    public static void closeFile(RandomAccessFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeStream(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeStream(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showTooltipNow(JComponent c) {
        Action toolTipAction = c.getActionMap().get("postTip");
        if (toolTipAction != null) {
            ActionEvent postTip = new ActionEvent(c, 1001, "");
            toolTipAction.actionPerformed(postTip);
        }
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1000L) {
            return Long.toString(bytes) + " Bytes";
        }
        if (bytes < 1000000L) {
            return FORMAT_2_DEC.format((double)bytes / 1024.0) + " KiByte";
        }
        if (bytes < 1000000000L) {
            return FORMAT_2_DEC.format((double)bytes / 1048576.0) + " MiByte";
        }
        return FORMAT_2_DEC.format((double)bytes / 1.073741824E9) + " GiByte";
    }

    public static String formatDurationSeconds(long seconds) {
        String min;
        String d;
        int years;
        int months;
        String m;
        long x = seconds;
        long days = x / SECONDS_PER_DAY;
        x %= SECONDS_PER_DAY;
        String string = m = (months = (int)((double)(days -= (long)((years = (int)(days / 365L)) * 365)) * 12.0 / 365.0)) == 1 ? "month" : "months";
        if (years > 5) {
            return String.format("%d years", years);
        }
        if (years > 0) {
            String y = years == 1 ? "year" : "years";
            return String.format("%d %s %d %s", years, y, months, m);
        }
        String string2 = d = days == 1L ? "day" : "days";
        if (months > 0) {
            days = (long)((double)days - (double)months * 30.416666666666668);
            return String.format("%d %s %d %s", months, m, days, d);
        }
        long hours = TimeUnit.SECONDS.toHours(x);
        String h = hours == 1L ? "hour" : "hours";
        x -= hours * SECONDS_PER_HOUR;
        if (days > 0L) {
            return String.format("%d %s %d %s", days, d, hours, h);
        }
        long minutes = TimeUnit.SECONDS.toMinutes(x);
        String string3 = min = minutes == 1L ? "minute" : "minutes";
        if (hours > 0L) {
            return String.format("%d %s %d %s", hours, h, minutes, min);
        }
        return String.format("%d %s", minutes, min);
    }

    public static void mkDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdir()) {
            throw new IOException("Failed to create directory \"" + dir.getAbsolutePath() + "\"");
        }
    }

    public static void mkDirs(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Failed to create directory \"" + dir.getAbsolutePath() + "\"");
        }
    }

    public static File[] listSubDirectories(File dir) {
        return dir.listFiles(new DirectoryFileFilter());
    }

    public static void addSubDirectories(List<File> dirList, File dir, int maxDepth) {
        File[] subDirs;
        for (File f : subDirs = dir.listFiles(new DirectoryFileFilter())) {
            dirList.add(f);
            if (maxDepth <= 0) continue;
            Utilities.addSubDirectories(dirList, f, maxDepth - 1);
        }
    }

    public static String prettyPrintLatLon(double coord, boolean isCoordKindLat) {
        boolean neg;
        boolean bl = neg = coord < 0.0;
        String c = isCoordKindLat ? (neg ? "S" : "N") : (neg ? "W" : "E");
        double tAbsCoord = Math.abs(coord);
        int tDegree = (int)tAbsCoord;
        double tTmpMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        int tMinutes = (int)tTmpMinutes;
        double tSeconds = (tTmpMinutes - (double)tMinutes) * 60.0;
        return c + tDegree + "\u00b0" + cDmsMinuteFormatter.format(tMinutes) + "'" + cDmsSecondFormatter.format(tSeconds) + "\"";
    }

    public static void setHttpProxyHost(String host) {
        if (host != null && host.length() > 0) {
            System.setProperty("http.proxyHost", host);
        } else {
            System.getProperties().remove("http.proxyHost");
        }
    }

    public static void setHttpProxyPort(String port) {
        if (port != null && port.length() > 0) {
            System.setProperty("http.proxyPort", port);
        } else {
            System.getProperties().remove("http.proxyPort");
        }
    }

    public static File getClassLocation(Class<?> mainClass) {
        File f;
        ProtectionDomain pDomain = mainClass.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL loc = cSource.getLocation();
        try {
            f = new File(loc.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to determine program directory: ", e);
        }
        if (f.isDirectory()) {
            return f;
        }
        return f.getParentFile();
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        if (!fileToDelete.delete()) {
            throw new IOException("Deleting of \"" + fileToDelete + "\" failed.");
        }
    }
}

