/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mobac.utilities.stream.CountingOutputStream;
import mobac.utilities.tar.TarHeader;
import mobac.utilities.tar.TarRecord;

public class TarArchive {
    protected CountingOutputStream tarFileStream;
    protected File tarFile;
    protected File baseDir;

    public TarArchive(File tarFile, File baseDir) throws FileNotFoundException {
        this.tarFile = tarFile;
        this.tarFileStream = new CountingOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile, false)));
        this.baseDir = baseDir;
    }

    public long getTarFilePos() {
        return this.tarFileStream.getBytesWritten();
    }

    public boolean writeContentFromDir(File dirToAdd) throws IOException {
        if (!dirToAdd.isDirectory()) {
            return false;
        }
        TarHeader th = new TarHeader(dirToAdd, this.baseDir);
        this.writeTarHeader(th);
        Object[] files = dirToAdd.listFiles();
        Arrays.sort(files);
        for (Object f : files) {
            if (!((File)f).isDirectory()) {
                this.writeFile((File)f);
                continue;
            }
            this.writeContentFromDir((File)f);
        }
        return true;
    }

    public void writeFile(File fileOrDirToAdd) throws IOException {
        TarHeader th = new TarHeader(fileOrDirToAdd, this.baseDir);
        this.writeTarHeader(th);
        if (!fileOrDirToAdd.isDirectory()) {
            TarRecord tr = new TarRecord(fileOrDirToAdd);
            this.tarFileStream.write(tr.getRecordContent());
        }
    }

    public void writeDirectory(String dirName) throws IOException {
        TarHeader th = new TarHeader(dirName, 0, true);
        this.writeTarHeader(th);
    }

    public void writeFileFromData(String fileName, byte[] data) throws IOException {
        this.writeFileFromData(fileName, data, 0, data.length);
    }

    public void writeFileFromData(String fileName, byte[] data, int off, int len) throws IOException {
        TarHeader th = new TarHeader(fileName, len, false);
        this.writeTarHeader(th);
        TarRecord tr = new TarRecord(data, off, len);
        this.tarFileStream.write(tr.getRecordContent());
    }

    protected void writeTarHeader(TarHeader th) throws IOException {
        this.tarFileStream.write(th.getBytes());
    }

    public void writeEndofArchive() throws IOException {
        byte[] endOfArchive = new byte[1024];
        this.tarFileStream.write(endOfArchive);
        this.tarFileStream.flush();
    }

    public void close() {
        try {
            this.tarFileStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tarFileStream = null;
    }

    public File getTarFile() {
        return this.tarFile;
    }
}

