/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarArchive;
import mobac.utilities.tar.TarHeader;

public class TarTmiArchive
extends TarArchive {
    Writer tmiWriter;

    public TarTmiArchive(File tarFile, File baseDir) throws IOException {
        super(tarFile, baseDir);
        String tmiFilename = tarFile.getAbsolutePath();
        if (tmiFilename.toLowerCase().endsWith(".tar")) {
            tmiFilename = tmiFilename.substring(0, tmiFilename.length() - 4);
        }
        this.tmiWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmiFilename + ".tmi"), "ISO-8859-1"));
    }

    @Override
    public void writeEndofArchive() throws IOException {
        super.writeEndofArchive();
        this.tmiWriter.flush();
    }

    @Override
    public void close() {
        super.close();
        Utilities.closeWriter(this.tmiWriter);
    }

    @Override
    protected void writeTarHeader(TarHeader th) throws IOException {
        long streamPos = this.getTarFilePos();
        int block = (int)(streamPos >> 9);
        String line = String.format("block %10d: %s\n", block, th.getFileName());
        this.tmiWriter.write(line);
        super.writeTarHeader(th);
    }
}

