/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public abstract class JMapController {
    protected final JMapViewer map;
    protected boolean enabled = false;

    public JMapController(JMapViewer map) {
        this.map = map;
    }

    public JMapController(JMapViewer map, boolean enabled) {
        this(map);
        if (enabled) {
            this.enable();
        }
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        if (this instanceof MouseListener) {
            this.map.addMouseListener((MouseListener)((Object)this));
        }
        if (this instanceof MouseWheelListener) {
            this.map.addMouseWheelListener((MouseWheelListener)((Object)this));
        }
        if (this instanceof MouseMotionListener) {
            this.map.addMouseMotionListener((MouseMotionListener)((Object)this));
        }
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        if (this instanceof MouseListener) {
            this.map.removeMouseListener((MouseListener)((Object)this));
        }
        if (this instanceof MouseWheelListener) {
            this.map.removeMouseWheelListener((MouseWheelListener)((Object)this));
        }
        if (this instanceof MouseMotionListener) {
            this.map.removeMouseMotionListener((MouseMotionListener)((Object)this));
        }
        this.enabled = false;
    }
}

