/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mobac.mapsources.MultiLayerMapSource;
import mobac.utilities.Utilities;
import org.openstreetmap.gui.jmapviewer.DefaultMapTileLayer;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MapGridLayer;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OverlayMapTileLayer;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.MapLayer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;
import org.openstreetmap.gui.jmapviewer.interfaces.MapTileLayer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileImageCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderJobCreator;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    protected TileLoaderJobCreator tileLoader;
    protected TileImageCache tileCache;
    protected MapSource mapSource;
    protected boolean usePlaceHolderTiles = true;
    protected List<MapMarker> mapMarkerList;
    protected boolean mapMarkersVisible;
    protected MapGridLayer mapGridLayer = null;
    protected List<MapTileLayer> mapTileLayers;
    public List<MapLayer> mapLayers;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider = new JSlider(0, 0);
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    JobDispatcher jobDispatcher;

    public JMapViewer(MapSource defaultMapSource, TileImageCache tileCache, int downloadThreadCount) {
        this.mapTileLayers = new LinkedList<MapTileLayer>();
        this.mapLayers = new LinkedList<MapLayer>();
        this.tileLoader = new OsmTileLoader(this);
        this.tileCache = tileCache;
        this.jobDispatcher = JobDispatcher.getInstance();
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapMarkersVisible = true;
        this.setLayout(null);
        this.setMapSource(defaultMapSource);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(256, 256));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPositionByLatLon(50.0, 9.0, 3);
    }

    protected void initializeZoomSlider() {
        ImageIcon icon;
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.add(this.zoomSlider);
        int size = 18;
        try {
            icon = Utilities.loadResourceImageIcon("plus.png");
            this.zoomInButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, size, size);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomIn();
            }
        });
        this.add(this.zoomInButton);
        try {
            icon = Utilities.loadResourceImageIcon("minus.png");
            this.zoomOutButton = new JButton(icon);
        }
        catch (Exception e) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + size, 155, size, size);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMapViewer.this.zoomOut();
            }
        });
        this.add(this.zoomOutButton);
    }

    public void setDisplayPositionByLatLon(double lat, double lon, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), lat, lon, zoom);
    }

    public void setDisplayPositionByLatLon(Point mapPoint, double lat, double lon, int zoom) {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        int x = mapSpace.cLonToX(lon, zoom);
        int y = mapSpace.cLatToY(lat, zoom);
        this.setDisplayPosition(mapPoint, x, y, zoom);
    }

    public void setDisplayPosition(int x, int y, int zoom) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), x, y, zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point mapPoint, int x, int y, int zoom) {
        if (zoom > this.mapSource.getMaxZoom() || zoom < 0) {
            return;
        }
        Point p = new Point();
        p.x = x - mapPoint.x + this.getWidth() / 2;
        p.y = y - mapPoint.y + this.getHeight() / 2;
        this.center = p;
        this.setIgnoreRepaint(true);
        try {
            int oldZoom = this.zoom;
            this.zoom = zoom;
            if (oldZoom != zoom) {
                this.zoomChanged(oldZoom);
            }
            if (this.zoomSlider.getValue() != zoom) {
                this.zoomSlider.setValue(zoom);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    public void setDisplayToFitPixelCoordinates(int x1, int y1, int x2, int y2) {
        int y;
        int mapZoomMax = this.mapSource.getMaxZoom();
        int height = Math.max(0, this.getHeight());
        int width = Math.max(0, this.getWidth());
        int newZoom = 22;
        int x = Math.abs(x1 - x2);
        for (y = Math.abs(y1 - y2); x > width || y > height || newZoom > mapZoomMax; --newZoom, x >>= 1, y >>= 1) {
        }
        newZoom = Math.max(this.mapSource.getMinZoom(), Math.min(this.mapSource.getMaxZoom(), newZoom));
        x = Math.min(x2, x1) + Math.abs(x1 - x2) / 2;
        y = Math.min(y2, y1) + Math.abs(y1 - y2) / 2;
        int z = 1 << 22 - newZoom;
        this.setDisplayPosition(x /= z, y /= z, newZoom);
    }

    public Point2D.Double getPosition(Point mapPoint) {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        int x = this.center.x + mapPoint.x - this.getWidth() / 2;
        int y = this.center.y + mapPoint.y - this.getHeight() / 2;
        double lon = mapSpace.cXToLon(x, this.zoom);
        double lat = mapSpace.cYToLat(y, this.zoom);
        return new Point2D.Double(lat, lon);
    }

    public Point getMapPosition(double lat, double lon) {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        int x = mapSpace.cLonToX(lon, this.zoom);
        int y = mapSpace.cLatToY(lat, this.zoom);
        if ((x -= this.center.x - this.getWidth() / 2) < 0 || (y -= this.center.y - this.getHeight() / 2) < 0 || x > this.getWidth() || y > this.getHeight()) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean start_top;
        Graphics2D g = (Graphics2D)graphics;
        super.paintComponent(g);
        int iMove = 0;
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        int tilex = this.center.x / tileSize;
        int tiley = this.center.y / tileSize;
        int off_x = this.center.x % tileSize;
        int off_y = this.center.y % tileSize;
        int w2 = this.getWidth() / 2;
        int h2 = this.getHeight() / 2;
        int topLeftX = this.center.x - w2;
        int topLeftY = this.center.y - h2;
        int posx = w2 - off_x;
        int posy = h2 - off_y;
        int diff_left = off_x;
        int diff_right = tileSize - off_x;
        int diff_top = off_y;
        int diff_bottom = tileSize - off_y;
        boolean start_left = diff_left < diff_right;
        boolean bl = start_top = diff_top < diff_bottom;
        iMove = start_top ? (start_left ? 2 : 3) : (start_left ? 1 : 0);
        int x_min = -tileSize;
        int y_min = -tileSize;
        int x_max = this.getWidth();
        int y_max = this.getHeight();
        boolean painted = this.mapTileLayers.size() > 0;
        for (MapTileLayer l : this.mapTileLayers) {
            l.startPainting(this.mapSource);
        }
        int x = 0;
        while (painted) {
            painted = false;
            for (int i = 0; i < 4; ++i) {
                if (i % 2 == 0) {
                    ++x;
                }
                for (int j = 0; j < x; ++j) {
                    if (x_min <= posx && posx <= x_max && y_min <= posy && posy <= y_max) {
                        painted = true;
                        for (MapTileLayer mapTileLayer : this.mapTileLayers) {
                            mapTileLayer.paintTile(g, posx, posy, tilex, tiley, this.zoom);
                        }
                    }
                    Point p = move[iMove];
                    posx += p.x * tileSize;
                    posy += p.y * tileSize;
                    tilex += p.x;
                    tiley += p.y;
                }
                iMove = (iMove + 1) % move.length;
            }
        }
        int bottomRightX = topLeftX + this.getWidth();
        int bottomRightY = topLeftY + this.getHeight();
        for (MapLayer mapLayer : this.mapLayers) {
            mapLayer.paint(this, g, this.zoom, topLeftX, topLeftY, bottomRightX, bottomRightY);
        }
        int mapSize = tileSize << this.zoom;
        g.drawRect(w2 - this.center.x, h2 - this.center.y, mapSize, mapSize);
        if (!this.mapMarkersVisible || this.mapMarkerList == null) {
            return;
        }
        for (MapMarker marker : this.mapMarkerList) {
            Point p = this.getMapPosition(marker.getLat(), marker.getLon());
            if (p == null) continue;
            marker.paint(g, p);
        }
    }

    public void moveMap(int x, int y) {
        this.center.x += x;
        this.center.y += y;
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point mapPoint) {
        this.setZoom(this.zoom + 1, mapPoint);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void setZoom(int zoom, Point mapPoint) {
        if (zoom > this.mapSource.getMaxZoom() || zoom < this.mapSource.getMinZoom() || zoom == this.zoom) {
            return;
        }
        Point2D.Double zoomPos = this.getPosition(mapPoint);
        this.jobDispatcher.cancelOutstandingJobs();
        this.setDisplayPositionByLatLon(mapPoint, zoomPos.x, zoomPos.y, zoom);
    }

    public void setZoom(int zoom) {
        this.setZoom(zoom, new Point(this.getWidth() / 2, this.getHeight() / 2));
        this.repaint();
    }

    protected void zoomChanged(int oldZoom) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.mapSource.getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.mapSource.getMaxZoom());
    }

    public void setZoomContolsVisible(boolean visible) {
        this.zoomSlider.setVisible(visible);
        this.zoomInButton.setVisible(visible);
        this.zoomOutButton.setVisible(visible);
    }

    @Override
    public TileImageCache getTileImageCache() {
        return this.tileCache;
    }

    public void setTileLoader(TileLoaderJobCreator tileLoader) {
        this.tileLoader = tileLoader;
    }

    public MapSource getMapSource() {
        return this.mapSource;
    }

    public void setMapSource(MapSource mapSource) {
        if (mapSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (mapSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        this.mapSource = mapSource;
        this.zoomSlider.setMinimum(mapSource.getMinZoom());
        this.zoomSlider.setMaximum(mapSource.getMaxZoom());
        this.jobDispatcher.cancelOutstandingJobs();
        if (this.zoom > mapSource.getMaxZoom()) {
            this.setZoom(mapSource.getMaxZoom());
        }
        this.mapTileLayers.clear();
        if (mapSource instanceof MultiLayerMapSource) {
            MapSource background = ((MultiLayerMapSource)mapSource).getBackgroundMapSource();
            this.mapTileLayers.add(new DefaultMapTileLayer(this, background));
            this.mapTileLayers.add(new OverlayMapTileLayer(this, mapSource));
        } else {
            this.mapTileLayers.add(new DefaultMapTileLayer(this, mapSource));
        }
        if (this.mapGridLayer != null) {
            this.mapTileLayers.add(this.mapGridLayer);
        }
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean success) {
        this.repaint();
    }
}

