/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.ByteArrayInputStream;
import mobac.program.download.TileDownLoader;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileImageCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final Logger log = Logger.getLogger(OsmFileCacheTileLoader.class);
    protected TileStore tileStore = TileStore.getInstance();

    public OsmFileCacheTileLoader(TileLoaderListener map) {
        super(map);
    }

    @Override
    public Runnable createTileLoaderJob(MapSource source, int tilex, int tiley, int zoom) {
        return new TileAsyncLoadJob(source, tilex, tiley, zoom);
    }

    protected class TileAsyncLoadJob
    implements Runnable {
        final int tilex;
        final int tiley;
        final int zoom;
        final MapSource mapSource;
        Tile tile;
        boolean fileTilePainted = false;
        protected TileStoreEntry tileStoreEntry = null;

        public TileAsyncLoadJob(MapSource source, int tilex, int tiley, int zoom) {
            this.mapSource = source;
            this.tilex = tilex;
            this.tiley = tiley;
            this.zoom = zoom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TileImageCache cache;
            TileImageCache tileImageCache = cache = OsmFileCacheTileLoader.this.listener.getTileImageCache();
            synchronized (tileImageCache) {
                this.tile = cache.getTile(this.mapSource, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.tileState != Tile.TileState.TS_NEW) {
                    return;
                }
                this.tile.setTileState(Tile.TileState.TS_LOADING);
            }
            if (this.loadTileFromStore()) {
                return;
            }
            if (this.fileTilePainted) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        TileAsyncLoadJob.this.loadOrUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob(job);
            } else {
                this.loadOrUpdateTile();
            }
        }

        protected void loadOrUpdateTile() {
            try {
                byte[] buffer;
                if (this.tileStoreEntry == null) {
                    buffer = TileDownLoader.downloadTileAndUpdateStore(this.tilex, this.tiley, this.zoom, this.mapSource);
                } else {
                    TileDownLoader.updateStoredTile(this.tileStoreEntry, this.mapSource);
                    buffer = this.tileStoreEntry.getData();
                }
                if (buffer != null) {
                    this.tile.loadImage(new ByteArrayInputStream(buffer));
                    this.tile.setTileState(Tile.TileState.TS_LOADED);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                } else {
                    this.tile.setErrorImage();
                }
            }
            catch (Exception e) {
                log.trace("Downloading of tile " + this.tile + " failed", e);
                this.tile.setErrorImage();
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, false);
            }
        }

        protected boolean loadTileFromStore() {
            try {
                this.tileStoreEntry = OsmFileCacheTileLoader.this.tileStore.getTile(this.tilex, this.tiley, this.zoom, this.mapSource);
                if (this.tileStoreEntry == null) {
                    return false;
                }
                this.tile.loadImage(new ByteArrayInputStream(this.tileStoreEntry.getData()));
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                if (TileDownLoader.isTileExpired(this.tileStoreEntry)) {
                    return false;
                }
                this.fileTilePainted = true;
                return true;
            }
            catch (Exception e) {
                log.error("", e);
                return false;
            }
        }
    }
}

