/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileImageCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderJobCreator;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmTileLoader
implements TileLoaderJobCreator {
    private static final Logger log = Logger.getLogger(OsmTileLoader.class);
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener listener) {
        this.listener = listener;
    }

    @Override
    public Runnable createTileLoaderJob(final MapSource source, final int tilex, final int tiley, final int zoom) {
        return new Runnable(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    Tile tile;
                    TileImageCache cache;
                    TileImageCache tileImageCache = cache = OsmTileLoader.this.listener.getTileImageCache();
                    synchronized (tileImageCache) {
                        tile = cache.getTile(source, tilex, tiley, zoom);
                        if (tile == null || tile.tileState == Tile.TileState.TS_LOADED || tile.tileState == Tile.TileState.TS_ERROR) {
                            return;
                        }
                    }
                    try {
                        this.input = OsmTileLoader.this.loadTileFromOsm(tile).getInputStream();
                        tile.loadImage(this.input);
                        tile.setTileState(Tile.TileState.TS_LOADED);
                        OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                        this.input.close();
                        this.input = null;
                    }
                    catch (Exception e) {
                        tile.setErrorImage();
                        OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                        if (this.input != null) break block6;
                        log.error("failed loading " + zoom + "/" + tilex + "/" + tiley + " " + e.getMessage());
                    }
                }
            }
        };
    }

    protected HttpURLConnection loadTileFromOsm(Tile tile) throws IOException {
        HttpURLConnection urlConn = tile.getUrlConnection();
        urlConn.setReadTimeout(30000);
        return urlConn;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

