/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapTileLayer;

public class OverlayMapTileLayer
implements MapTileLayer {
    protected JMapViewer mapViewer;
    protected MapSource mapSource;

    public OverlayMapTileLayer(JMapViewer mapViewer, MapSource tileSource) {
        this.mapViewer = mapViewer;
        this.mapSource = tileSource;
    }

    @Override
    public void startPainting(MapSource mapSource) {
    }

    @Override
    public void paintTile(Graphics g, int gx, int gy, int tilex, int tiley, int zoom) {
        Tile tile = this.getTile(tilex, tiley, zoom);
        if (tile == null) {
            return;
        }
        tile.paintTransparent(g, gx, gy);
    }

    protected Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.mapViewer.tileCache.getTile(this.mapSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new Tile(this.mapSource, tilex, tiley, zoom);
            this.mapViewer.tileCache.addTile(tile);
        }
        if (tile.getTileState() == Tile.TileState.TS_NEW) {
            this.mapViewer.jobDispatcher.addJob(this.mapViewer.tileLoader.createTileLoaderJob(this.mapSource, tilex, tiley, zoom));
        }
        return tile;
    }
}

